/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1496;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5134;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class InfoLineHorseJump
extends InfoLine {
    private static final String HORSE_KEY = "minihud.info_line.horse_jump";

    public InfoLineHorseJump(InfoToggle type) {
        super(type);
    }

    public InfoLineHorseJump() {
        super(InfoToggle.HORSE_JUMP);
    }

    @Override
    public boolean succeededType() {
        return this.succeeded;
    }

    @Override
    public List<InfoLine.Entry> parse(@NotNull InfoLine.Context ctx) {
        class_1297 vehicle;
        if (ctx.world() == null) {
            return null;
        }
        if (this.mc().field_1724 != null && (vehicle = Objects.requireNonNull(this.mc().field_1724).method_5854()) instanceof class_1496) {
            return this.parseEnt(ctx.world(), vehicle);
        }
        if (ctx.hasLiving() && ctx.hasNbt()) {
            class_1299 entityType = NbtEntityUtils.getEntityTypeFromNbt((class_2487)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        if (ctx.ent() != null) {
            return this.parseEnt(ctx.world(), ctx.ent());
        }
        return null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@NotNull class_1937 world, @NotNull class_1299<?> entityType, @NotNull class_2487 nbt) {
        Pair horsePair;
        double jump;
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        String horseType = entityType.method_5897().getString();
        if ((entityType.equals((Object)class_1299.field_40116) || entityType.equals((Object)class_1299.field_6067) || entityType.equals((Object)class_1299.field_6139) || entityType.equals((Object)class_1299.field_6074) || entityType.equals((Object)class_1299.field_6057) || entityType.equals((Object)class_1299.field_6075) || entityType.equals((Object)class_1299.field_17714) || entityType.equals((Object)class_1299.field_6048)) && (jump = ((Double)(horsePair = NbtEntityUtils.getSpeedAndJumpStrengthFromNbt((class_2487)nbt)).getRight()).doubleValue()) > 0.0) {
            double calculatedJumpHeight = -0.1817584952 * jump * jump * jump + 3.689713992 * jump * jump + 2.128599134 * jump + -0.343930367;
            list.add(this.translate(HORSE_KEY, horseType, calculatedJumpHeight));
            this.succeeded = true;
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@NotNull class_1937 world, @NotNull class_1297 ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (ent instanceof class_1496) {
            class_1496 horse = (class_1496)ent;
            String horseType = horse.method_5864().method_5897().getString();
            double jump = horse.method_45325(class_5134.field_23728);
            if (jump > 0.0) {
                double calculatedJumpHeight = -0.1817584952 * jump * jump * jump + 3.689713992 * jump * jump + 2.128599134 * jump + -0.343930367;
                list.add(this.translate(HORSE_KEY, horseType, calculatedJumpHeight));
                this.succeeded = true;
            }
        }
        return list;
    }
}

