/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.renderer.shapes.ShapeCircleBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_9801;

public class ShapeSphereBlocky
extends ShapeCircleBase {
    private boolean hasData = false;

    public ShapeSphereBlocky() {
        this(ShapeType.SPHERE_BLOCKY, Configs.Colors.SHAPE_SPHERE_BLOCKY.getColor(), 16.0);
    }

    public ShapeSphereBlocky(ShapeType type, Color4f color, double radius) {
        super(type, color, radius);
        this.useCulling = true;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        this.hasData = true;
        this.render(cameraPos, mc, profiler);
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData;
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers(this.renderLines);
        this.renderQuads(cameraPos, mc, profiler);
        if (this.renderLines) {
            this.renderOutlines(cameraPos, mc, profiler);
        }
    }

    private void renderQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("sphere_blocky_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:sphere_blocky/quads", this.renderThroughShape ? MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH_OFFSET : MaLiLibPipelines.MINIHUD_SHAPE_OFFSET);
        this.renderSphereShapeQuads(cameraPos, builder);
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("ShapeSphereBlocky#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null || !this.renderLines) {
            return;
        }
        profiler.method_15396("sphere_blocky_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:sphere_blocky/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        this.renderSphereShapeOutlines(cameraPos, builder);
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("ShapeSphereBlocky#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.hasData = false;
    }

    protected SphereUtils.RingPositionTest getPositionTest() {
        return (x, y, z, dir) -> SphereUtils.isPositionInsideOrClosestToRadiusOnBlockRing(x, y, z, this.getEffectiveCenter(), this.getSquaredRadius(), class_2350.field_11034);
    }

    protected double getTotalRadius() {
        return this.getRadius();
    }

    protected void renderSphereShapeQuads(class_243 cameraPos, class_287 builder) {
        SphereUtils.RingPositionTest test = this.getPositionTest();
        LongOpenHashSet positions = new LongOpenHashSet();
        Consumer<class_2338.class_2339> positionConsumer = this.getPositionCollector(positions);
        class_2338 centerPos = this.getCenterBlock();
        double expand = 0.0;
        SphereUtils.collectSpherePositions(positionConsumer, test, centerPos, (int)this.getTotalRadius());
        if (this.getCombineQuads()) {
            List<SideQuad> quads = SphereUtils.buildSphereShellToQuads(positions, this.mainAxis.method_10166(), test, this.renderType, this.layerRange);
            RenderUtils.renderQuads(quads, this.color, expand, cameraPos, builder);
        } else {
            RenderUtils.renderCircleBlockPositions(positions, PositionUtils.ALL_DIRECTIONS, test, this.renderType, this.layerRange, this.color, expand, cameraPos, builder);
        }
    }

    protected void renderSphereShapeOutlines(class_243 cameraPos, class_287 builder) {
        SphereUtils.RingPositionTest test = this.getPositionTest();
        LongOpenHashSet positions = new LongOpenHashSet();
        Consumer<class_2338.class_2339> positionConsumer = this.getPositionCollector(positions);
        class_2338 centerPos = this.getCenterBlock();
        double expand = 0.0;
        SphereUtils.collectSpherePositions(positionConsumer, test, centerPos, (int)this.getTotalRadius());
        if (this.getCombineQuads()) {
            List<SideQuad> quads = SphereUtils.buildSphereShellToQuads(positions, this.mainAxis.method_10166(), test, this.renderType, this.layerRange);
            RenderUtils.renderQuadLines(quads, this.colorLines, expand, cameraPos, builder);
        } else {
            RenderUtils.renderCircleBlockOutlines(positions, PositionUtils.ALL_DIRECTIONS, test, this.renderType, this.layerRange, this.colorLines, expand, cameraPos, builder);
        }
    }
}

