/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal.chunkUpdating;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.api.internal.chunkUpdating.ChunkPosQueue;
import com.seibel.distanthorizons.core.api.internal.chunkUpdating.ChunkUpdateData;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import org.apache.logging.log4j.Logger;

public class ChunkUpdateQueueManager {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final ChunkPosQueue updateQueue = new ChunkPosQueue();
    public final ChunkPosQueue preUpdateQueue = new ChunkPosQueue();
    public int maxSize = 500;
    private static long lastOverloadedLogMessageMsTime = 0L;

    public boolean contains(DhChunkPos pos) {
        return this.updateQueue.contains(pos) || this.preUpdateQueue.contains(pos);
    }

    public void clear() {
        this.updateQueue.clear();
        this.preUpdateQueue.clear();
    }

    public int getQueuedCount() {
        return this.updateQueue.getQueuedCount() + this.preUpdateQueue.getQueuedCount();
    }

    public boolean isEmpty() {
        return this.updateQueue.isEmpty() && this.preUpdateQueue.isEmpty();
    }

    public void addItemToPreUpdateQueue(DhChunkPos pos, ChunkUpdateData updateData) {
        int remainingSlots = this.maxSize - this.getQueuedCount();
        if (remainingSlots <= 0) {
            if (!this.updateQueue.isEmpty()) {
                this.updateQueue.popFurthest();
            } else {
                this.preUpdateQueue.popFurthest();
            }
        }
        this.preUpdateQueue.addItem(pos, updateData);
        remainingSlots = this.maxSize - this.getQueuedCount();
        if (remainingSlots <= 0) {
            this.sendOverloadMessage();
        }
    }

    public void addItemToUpdateQueue(DhChunkPos pos, ChunkUpdateData updateData) {
        int remainingSlots = this.maxSize - this.getQueuedCount();
        if (remainingSlots <= 0) {
            this.updateQueue.popFurthest();
        }
        this.updateQueue.addItem(pos, updateData);
        remainingSlots = this.maxSize - this.getQueuedCount();
        if (remainingSlots <= 0) {
            this.sendOverloadMessage();
        }
    }

    private void sendOverloadMessage() {
        long msBetweenLastLog = System.currentTimeMillis() - lastOverloadedLogMessageMsTime;
        if (msBetweenLastLog >= 30000L) {
            lastOverloadedLogMessageMsTime = System.currentTimeMillis();
            String message = "\u00a76Distant Horizons overloaded, too many chunks queued for LOD processing. \u00a7r\nThis may result in holes in your LODs. \nFix: move through the world slower, decrease your vanilla render distance, slow down your world pre-generator (IE Chunky), or increase the Distant Horizons' CPU thread counts. \nMax queue count [" + SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.maxSize + "] ([" + 1000 + "] per thread+players).";
            boolean showWarningInChat = Config.Common.Logging.Warning.showUpdateQueueOverloadedChatWarning.get();
            if (showWarningInChat) {
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            EWorldEnvironment environment = SharedApi.getEnvironment();
            if (showWarningInChat || environment == EWorldEnvironment.SERVER_ONLY) {
                LOGGER.warn(message);
            }
        }
    }

    public void setCenter(DhChunkPos newCenter) {
        this.updateQueue.setCenter(newCenter);
        this.preUpdateQueue.setCenter(newCenter);
    }
}

