/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render;

import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnQuadView;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pooling.AbstractPhantomArrayList;
import com.seibel.distanthorizons.core.pooling.PhantomArrayListPool;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.coreapi.ModInfo;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;

public class ColumnRenderSource
extends AbstractPhantomArrayList {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final boolean DO_SAFETY_CHECKS = ModInfo.IS_DEV_BUILD;
    public static final byte SECTION_SIZE_OFFSET = 6;
    public static final int SECTION_SIZE = BitShiftUtil.powerOfTwo(6);
    public static final PhantomArrayListPool ARRAY_LIST_POOL = new PhantomArrayListPool("Render Source");
    public int verticalDataCount;
    public long pos;
    public int yOffset;
    public final LongArrayList renderDataContainer;
    public final DebugSourceFlag[] debugSourceFlags;
    private boolean isEmpty = true;
    public AtomicLong localVersion = new AtomicLong(0L);

    public static ColumnRenderSource createEmpty(long pos, int maxVerticalSize, int yOffset) {
        return new ColumnRenderSource(pos, maxVerticalSize, yOffset);
    }

    private ColumnRenderSource(long pos, int maxVerticalSize, int yOffset) {
        super(ARRAY_LIST_POOL, 0, 0, 1);
        this.pos = pos;
        this.yOffset = yOffset;
        this.verticalDataCount = maxVerticalSize;
        this.renderDataContainer = this.pooledArraysCheckout.getLongArray(0, SECTION_SIZE * SECTION_SIZE * this.verticalDataCount);
        this.debugSourceFlags = new DebugSourceFlag[SECTION_SIZE * SECTION_SIZE];
    }

    public long getDataPoint(int posX, int posZ, int verticalIndex) {
        return this.renderDataContainer.getLong(posX * SECTION_SIZE * this.verticalDataCount + posZ * this.verticalDataCount + verticalIndex);
    }

    public ColumnArrayView getVerticalDataPointView(int posX, int posZ) {
        int offset = posX * SECTION_SIZE * this.verticalDataCount + posZ * this.verticalDataCount;
        if (offset >= this.renderDataContainer.size()) {
            return null;
        }
        if (posX < 0 || posX >= SECTION_SIZE || posZ < 0 || posZ >= SECTION_SIZE) {
            return null;
        }
        return new ColumnArrayView(this.renderDataContainer, this.verticalDataCount, offset, this.verticalDataCount);
    }

    public ColumnQuadView getFullQuadView() {
        return this.getQuadViewOverRange(0, 0, SECTION_SIZE, SECTION_SIZE);
    }

    public ColumnQuadView getQuadViewOverRange(int quadX, int quadZ, int quadXSize, int quadZSize) {
        return new ColumnQuadView(this.renderDataContainer, SECTION_SIZE, this.verticalDataCount, quadX, quadZ, quadXSize, quadZSize);
    }

    public Long getPos() {
        return this.pos;
    }

    public Long getKey() {
        return this.pos;
    }

    public String getKeyDisplayString() {
        return DhSectionPos.toString(this.pos);
    }

    public byte getDataDetailLevel() {
        return (byte)(DhSectionPos.getDetailLevel(this.pos) - 6);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void markNotEmpty() {
        this.isEmpty = false;
    }

    public boolean hasNonVoidDataPoints() {
        if (this.isEmpty) {
            return false;
        }
        for (int x = 0; x < SECTION_SIZE; ++x) {
            for (int z = 0; z < SECTION_SIZE; ++z) {
                ColumnArrayView columnArrayView = this.getVerticalDataPointView(x, z);
                for (int i = 0; i < columnArrayView.size; ++i) {
                    long dataPoint = columnArrayView.get(i);
                    if (RenderDataPointUtil.isVoid(dataPoint)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void fillDebugFlag(int xStart, int zStart, int xWidth, int zWidth, DebugSourceFlag flag) {
        for (int x = xStart; x < xStart + xWidth; ++x) {
            for (int z = zStart; z < zStart + zWidth; ++z) {
                this.debugSourceFlags[x * ColumnRenderSource.SECTION_SIZE + z] = flag;
            }
        }
    }

    public DebugSourceFlag debugGetFlag(int ox, int oz) {
        return this.debugSourceFlags[ox * SECTION_SIZE + oz];
    }

    public String toString() {
        String LINE_DELIMITER = "\n";
        String DATA_DELIMITER = " ";
        String SUBDATA_DELIMITER = ",";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DhSectionPos.toString(this.pos));
        stringBuilder.append(LINE_DELIMITER);
        int size = 1;
        for (int z = 0; z < size; ++z) {
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < this.verticalDataCount; ++y) {
                    stringBuilder.append(Long.toHexString(this.getDataPoint(x, z, y)));
                    if (y == this.verticalDataCount - 1) continue;
                    stringBuilder.append(SUBDATA_DELIMITER);
                }
                if (x == size - 1) continue;
                stringBuilder.append(DATA_DELIMITER);
            }
            if (z == size - 1) continue;
            stringBuilder.append(LINE_DELIMITER);
        }
        return stringBuilder.toString();
    }

    public static enum DebugSourceFlag {
        FULL(ColorUtil.BLUE),
        DIRECT(ColorUtil.WHITE),
        FILE(ColorUtil.BROWN);

        public final int color;

        private DebugSourceFlag(int color) {
            this.color = color;
        }
    }
}

