/*
 * Decompiled with CFR 0.152.
 */
package codes.atomys.advr;

import codes.atomys.advr.config.Configuration;
import codes.atomys.advr.utils.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_151;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_8781;

public class ReloadedCriterionProgress {
    private final class_8781 advancementNode;
    private final class_167 progress;
    private class_2960 criterion;
    private boolean obtained;
    private List<String> alreadyWarnedTranslations = Lists.newArrayList();

    public ReloadedCriterionProgress(class_8781 advancementNode, class_167 progress, String criterionName) {
        this.advancementNode = advancementNode;
        this.progress = progress;
        this.criterion = ReloadedCriterionProgress.sanitizeResourceLocationString(criterionName);
        this.obtained = progress.method_737(criterionName).method_784();
    }

    public class_8781 getAdvancementNode() {
        return this.advancementNode;
    }

    public class_161 getAdvancement() {
        return this.advancementNode.method_53649().comp_1920();
    }

    public class_2960 getResourceLocation() {
        return this.advancementNode.method_53649().comp_1919();
    }

    public class_167 getProgress() {
        return this.progress;
    }

    public class_2561 getTitle() {
        return class_2561.method_30163((String)this.criterion.toString());
    }

    public int getColor() {
        return this.isObtained() ? -16711936 : -65536;
    }

    public boolean isObtained() {
        return this.obtained;
    }

    public class_2561 getHumanCriterionName() {
        String translationKey = this.getTranslationKey();
        switch (Configuration.criteriasTranslationMode) {
            case NONE: {
                break;
            }
            case ONLY_COMPATIBLE: {
                return class_2561.method_48321((String)translationKey, (String)this.criterion.method_12832());
            }
            case TRY_TO_TRANSLATE: {
                return class_2561.method_48321((String)translationKey, (String)this.retrieveTranslationOnGame().getString());
            }
        }
        return class_2561.method_43470((String)this.criterion.method_12832());
    }

    public String getTranslationKey() {
        String criterionName = this.criterion.method_12832();
        List<String> parts = List.of("advancements", this.getAdvancementCategory(), this.getAdvancementIdentifier(), "criteria", criterionName);
        return parts.stream().filter(part -> part != null && !part.isEmpty()).collect(Collectors.joining("."));
    }

    private String getAdvancementIdentifier() {
        class_2960 locationId = this.getResourceLocation();
        String path = locationId.method_12832();
        String[] pathSegments = path.split("/");
        if (pathSegments.length == 0) {
            Utils.LOGGER.warn("advancement cannot be retrieved from the path: " + path);
            return "";
        }
        return pathSegments[pathSegments.length - 1];
    }

    private String getAdvancementCategory() {
        class_2960 locationId = this.getAdvancementNode().method_53652().method_53649().comp_1919();
        String path = locationId.method_12832();
        if (!path.contains("/")) {
            return "";
        }
        String[] pathSegments = path.split("/");
        if (pathSegments.length >= 2) {
            return pathSegments[pathSegments.length - 2];
        }
        return "";
    }

    private class_2561 retrieveTranslationOnGame() {
        String criterionNamespace = this.criterion.method_12836();
        String criteria = this.criterion.method_12832();
        ArrayList namespaces = Lists.newArrayList((Object[])new String[]{criterionNamespace});
        if (!criterionNamespace.equals("minecraft")) {
            namespaces.add("minecraft");
        }
        String[] keyTypes = new String[]{"biome", "block", "color", "container", "effect", "enchantment", "entity", "instrument", "item", "jukebox_song", "painting", "stat"};
        for (String namespace : namespaces) {
            String[] stringArray = keyTypes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String keyType;
                String translationKey = keyType + "." + namespace + "." + criteria + ((keyType = stringArray[i]) == "painting" ? ".title" : "");
                class_5250 translation = class_2561.method_43471((String)translationKey);
                if (translation.getString().equals(translationKey)) continue;
                translation.method_10866().method_10978(Boolean.valueOf(true)).method_27702(translation.method_10866());
                return translation;
            }
        }
        if (this.alreadyWarnedTranslations.contains(criteria)) {
            return class_2561.method_43470((String)criteria);
        }
        Utils.LOGGER.warn("Unable to translate {} to a more meaningful name, adding as is, performance may be degraded. You can add your own translation for this criterion by adding the translation key: `{}`.", (Object)criteria, (Object)this.getTranslationKey());
        this.alreadyWarnedTranslations.add(criteria);
        return class_2561.method_43470((String)criteria);
    }

    private static class_2960 sanitizeResourceLocationString(String str) {
        str = ((String)str).toLowerCase();
        try {
            return class_2960.method_60654((String)str);
        }
        catch (class_151 e) {
            Utils.LOGGER.error("Failed to parse criterion name: {}, trying to initial a ghost criterion", str);
            for (int i = 0; i < ((String)str).length(); ++i) {
                if (class_2960.method_29184((char)((String)str).charAt(i))) continue;
                str = ((String)str).substring(0, i) + "_" + ((String)str).substring(i + 1);
            }
            Utils.LOGGER.warn("Criterion name sanitized to: minecraft:{}. If you are the developer, please follow the minecraft naming convention (Non [a-z0-9/._-] character in path of location).", str);
            return class_2960.method_60655((String)"minecraft", (String)str);
        }
    }
}

