/*
 * Decompiled with CFR 0.152.
 */
package codes.atomys.advr.screens;

import codes.atomys.advr.ReloadedDisplayInfo;
import codes.atomys.advr.ReloadedWidgetType;
import codes.atomys.advr.TabPlacement;
import codes.atomys.advr.config.Configuration;
import codes.atomys.advr.screens.AdvancementReloadedScreen;
import codes.atomys.advr.screens.AdvancementReloadedWidget;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8779;
import net.minecraft.class_8781;
import org.jetbrains.annotations.Nullable;

public class AdvancementReloadedTab {
    private final class_310 client;
    private final AdvancementReloadedScreen screen;
    private final class_8781 root;
    private final ReloadedDisplayInfo display;
    private final class_1799 icon;
    private final class_2561 title;
    private final AdvancementReloadedWidget rootWidget;
    private final Map<class_8779, AdvancementReloadedWidget> widgets = Maps.newLinkedHashMap();
    private boolean doesAnyWidgetMatchSearch = true;
    private TabPlacement tabPlacement;
    private int index;
    private double originX;
    private double originY;
    private int minPanX = Integer.MAX_VALUE;
    private int minPanY = Integer.MAX_VALUE;
    private int maxPanX = Integer.MIN_VALUE;
    private int maxPanY = Integer.MIN_VALUE;
    private float alpha;
    private boolean initialized;
    private int tab_x;
    private int tab_y;
    private final RenderPipeline renderTypeGui = class_10799.field_56883;

    public AdvancementReloadedTab(class_310 client, AdvancementReloadedScreen screen, TabPlacement type, int index, class_8781 root, ReloadedDisplayInfo display) {
        this.client = client;
        this.screen = screen;
        this.tabPlacement = type;
        this.index = index;
        this.root = root;
        this.display = display;
        this.icon = display.method_821();
        this.title = display.method_811();
        this.rootWidget = new AdvancementReloadedWidget(this, client, root, display);
        this.addWidget(this.rootWidget, root.method_53649());
    }

    public TabPlacement getTabPlacement() {
        return this.tabPlacement;
    }

    public int getIndex() {
        return this.index;
    }

    public class_8781 getRoot() {
        return this.root;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public String getDisplayName() {
        return ((class_2561)this.getRoot().method_53647().comp_1918().orElse(class_2561.method_43470((String)this.getRoot().toString()))).getString();
    }

    public ReloadedDisplayInfo getDisplay() {
        return this.display;
    }

    public void setPos(int x, int y) {
        this.tab_x = x + this.tabPlacement.getTabX(this.index);
        this.tab_y = y + this.tabPlacement.getTabY(this.index);
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setTabPlacement(TabPlacement type) {
        this.tabPlacement = type;
    }

    public void drawBackground(class_332 context, boolean selected) {
        this.drawBackground(context, selected, 1.0f);
    }

    public void drawBackground(class_332 context, boolean selected, float alpha) {
        ReloadedWidgetType type = selected ? ReloadedWidgetType.OBTAINED : ReloadedWidgetType.UNOBTAINED;
        context.method_71501(this.renderTypeGui, type.frameSprite(class_189.field_1254, !this.isAnyWidgetMatchSearch()), this.tab_x, this.tab_y, this.tabPlacement.getWidth(), this.tabPlacement.getHeight(), alpha);
    }

    public void drawIcon(class_332 context) {
        context.method_51445(this.icon, this.tab_x + this.tabPlacement.getTopMargin(), this.tab_y + this.tabPlacement.getLeftMargin());
    }

    public int getWidth() {
        if (this.screen.hasVisibleSidebar()) {
            return this.screen.field_22789 - Configuration.criteriasWidth;
        }
        return this.screen.field_22789;
    }

    public int getHeight() {
        return this.screen.field_22790 - Configuration.headerHeight - Configuration.footerHeight - 2;
    }

    public boolean isAnyWidgetMatchSearch() {
        return this.doesAnyWidgetMatchSearch;
    }

    public void updateDoesWidgetMatchSearch() {
        for (AdvancementReloadedWidget widget : this.widgets.values()) {
            if (!widget.isSearchQueryMatched()) continue;
            this.doesAnyWidgetMatchSearch = true;
            return;
        }
        this.doesAnyWidgetMatchSearch = false;
    }

    public void render(class_332 context, int x, int y) {
        if (!this.initialized) {
            this.originX = this.getWidth() / 2 - (this.maxPanX + this.minPanX) / 2;
            this.originY = this.screen.field_22790 / 2 - Configuration.headerHeight - 1 - (this.maxPanY + this.minPanY) / 2;
            this.initialized = true;
        }
        context.method_44379(x, y, x + this.getWidth(), y + this.getHeight());
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)x, (float)y);
        int i = class_3532.method_15357((double)this.originX);
        int j = class_3532.method_15357((double)this.originY);
        this.rootWidget.renderLines(context, i, j, true);
        this.rootWidget.renderLines(context, i, j, false);
        this.rootWidget.renderWidgets(context, i, j);
        context.method_51448().popMatrix();
        context.method_44380();
    }

    public void drawWidgetTooltip(class_332 context, int mouseX, int mouseY, int x, int y) {
        context.method_25294(0, 0, this.getWidth(), this.getHeight(), class_3532.method_15375((float)(this.alpha * 255.0f)) << 24);
        boolean rendered = false;
        int i = class_3532.method_15357((double)this.originX);
        int j = class_3532.method_15357((double)this.originY);
        if (mouseX > 0 && mouseX < this.getWidth() && mouseY > 0 && mouseY < this.getHeight()) {
            for (AdvancementReloadedWidget advancementWidget : this.widgets.values()) {
                if (!advancementWidget.shouldRender(i, j, mouseX, mouseY)) continue;
                rendered = true;
                advancementWidget.drawTooltip(context, i, j, this.alpha, x, y);
                break;
            }
        }
        this.alpha = rendered ? class_3532.method_15363((float)(this.alpha + 0.02f), (float)0.0f, (float)0.3f) : class_3532.method_15363((float)(this.alpha - 0.04f), (float)0.0f, (float)1.0f);
    }

    public boolean isClickOnTab(int screenX, int screenY, double mouseX, double mouseY) {
        return mouseX > (double)this.tab_x && mouseX < (double)(this.tab_x + this.tabPlacement.getWidth()) && mouseY > (double)this.tab_y && mouseY < (double)(this.tab_y + this.tabPlacement.getHeight());
    }

    @Nullable
    public AdvancementReloadedWidget clickOnWidget(int screenX, int screenY, double mouseX, double mouseY) {
        int flooredOriginX = class_3532.method_15357((double)this.originX);
        int flooredOriginY = class_3532.method_15357((double)(this.originY + (double)Configuration.headerHeight - 1.0));
        if (mouseX < (double)screenX || mouseX > (double)this.getWidth() || mouseY < (double)screenY || mouseY > (double)(this.screen.field_22790 - Configuration.footerHeight - 1)) {
            return null;
        }
        for (AdvancementReloadedWidget advancementWidget : this.widgets.values()) {
            if (!advancementWidget.isMouseOn(flooredOriginX, flooredOriginY, mouseX, mouseY) || !advancementWidget.shouldRender(flooredOriginX, flooredOriginY, (int)mouseX, (int)mouseY)) continue;
            return advancementWidget;
        }
        return null;
    }

    @Nullable
    public static AdvancementReloadedTab create(class_310 client, AdvancementReloadedScreen screen, int index, class_8781 root) {
        Optional optional = root.method_53647().comp_1913();
        if (optional.isEmpty()) {
            return null;
        }
        for (TabPlacement advancementTabType : TabPlacement.values()) {
            if (index < advancementTabType.getTabLimit()) {
                return new AdvancementReloadedTab(client, screen, advancementTabType, index, root, ReloadedDisplayInfo.cast((class_185)optional.get()));
            }
            index -= advancementTabType.getTabLimit();
        }
        return null;
    }

    public void move(double offsetX, double offsetY) {
        int maxHeight;
        int maxWidth = this.getWidth();
        if (this.maxPanX - this.minPanX > maxWidth - 8) {
            this.originX = class_3532.method_15350((double)(this.originX + offsetX), (double)(-(this.maxPanX - maxWidth + 8)), (double)8.0);
        }
        if (this.maxPanY - this.minPanY > (maxHeight = this.getHeight()) - 16) {
            this.originY = class_3532.method_15350((double)(this.originY + offsetY), (double)(-(this.maxPanY - maxHeight + 16)), (double)16.0);
        }
    }

    public void addAdvancement(class_8781 advancement) {
        Optional optional = advancement.method_53647().comp_1913();
        if (optional.isPresent()) {
            AdvancementReloadedWidget advancementWidget = new AdvancementReloadedWidget(this, this.client, advancement, ReloadedDisplayInfo.cast((class_185)optional.get()));
            this.addWidget(advancementWidget, advancement.method_53649());
        }
    }

    private void addWidget(AdvancementReloadedWidget widget, class_8779 advancement) {
        this.widgets.put(advancement, widget);
        int widgetXPosition = widget.getX();
        int widgetXPositionOffset = widgetXPosition + 28;
        int widgetYPosition = widget.getY();
        int widgetYPositionOffset = widgetYPosition + 27;
        this.minPanX = Math.min(this.minPanX, widgetXPosition);
        this.maxPanX = Math.max(this.maxPanX, widgetXPositionOffset);
        this.minPanY = Math.min(this.minPanY, widgetYPosition);
        this.maxPanY = Math.max(this.maxPanY, widgetYPositionOffset);
        for (AdvancementReloadedWidget advancementWidget : this.widgets.values()) {
            advancementWidget.addToTree();
        }
    }

    @Nullable
    public AdvancementReloadedWidget getWidget(class_8779 advancement) {
        return this.widgets.get(advancement);
    }

    public AdvancementReloadedScreen getScreen() {
        return this.screen;
    }
}

