/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiScrollBar;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.gui.widgets.WidgetSearchBar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public abstract class WidgetListBase<TYPE, WIDGET extends WidgetListEntryBase<TYPE>>
extends GuiBase {
    protected final List<TYPE> listContents = new ArrayList<TYPE>();
    protected final List<WIDGET> listWidgets = new ArrayList<WIDGET>();
    protected final GuiScrollBar scrollBar = new GuiScrollBar();
    protected final Set<TYPE> selectedEntries = new HashSet<TYPE>();
    protected final int posX;
    protected final int posY;
    protected int totalWidth;
    protected int totalHeight;
    protected int browserWidth;
    protected int browserHeight;
    protected int entryHeight;
    protected int browserEntriesStartX;
    protected int browserEntriesStartY;
    protected int browserEntriesOffsetY;
    protected int browserEntryWidth;
    protected int browserEntryHeight;
    protected int browserPaddingX;
    protected int browserPaddingY;
    protected int maxVisibleBrowserEntries;
    protected int lastSelectedEntryIndex = -1;
    protected int lastScrollbarPosition = -1;
    protected boolean allowKeyboardNavigation;
    protected boolean allowMultiSelection;
    protected boolean shouldSortList;
    @Nullable
    private TYPE lastSelectedEntry;
    @Nullable
    private ISelectionListener<TYPE> selectionListener;
    @Nullable
    protected WidgetSearchBar widgetSearchBar;

    public WidgetListBase(int x, int y, int width, int height, @Nullable ISelectionListener<TYPE> selectionListener) {
        this.posX = x;
        this.posY = y;
        this.selectionListener = selectionListener;
        this.browserEntryHeight = 14;
        this.setSize(width, height);
    }

    protected void setSelectionListener(ISelectionListener<TYPE> listener) {
        this.selectionListener = listener;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.refreshEntries();
    }

    @Override
    public boolean onMouseClicked(class_11909 click, boolean doubleClick) {
        if (click.method_74228() == 0 && this.scrollBar.wasMouseOver()) {
            this.scrollBar.setIsDragging(true);
            return true;
        }
        if (this.onMouseClickedSearchBar(click, doubleClick)) {
            return true;
        }
        int relativeY = (int)(click.comp_4799() - (double)this.browserEntriesStartY - (double)this.browserEntriesOffsetY);
        if (relativeY >= 0 && click.comp_4798() >= (double)this.browserEntriesStartX && click.comp_4798() < (double)(this.browserEntriesStartX + this.browserEntryWidth)) {
            for (int i = 0; i < this.listWidgets.size(); ++i) {
                int entryIndex;
                WidgetListEntryBase widget = (WidgetListEntryBase)this.listWidgets.get(i);
                if (!widget.isMouseOver((int)click.comp_4798(), (int)click.comp_4799())) continue;
                if (widget.canSelectAt(click) && (entryIndex = widget.getListIndex()) >= 0 && entryIndex < this.listContents.size()) {
                    this.onEntryClicked(this.listContents.get(entryIndex), entryIndex);
                }
                return widget.onMouseClicked(click, doubleClick);
            }
        }
        return super.onMouseClicked(click, doubleClick);
    }

    @Override
    public boolean onMouseReleased(class_11909 click) {
        if (click.method_74228() == 0) {
            this.scrollBar.setIsDragging(false);
        }
        for (int i = 0; i < this.listWidgets.size(); ++i) {
            ((WidgetListEntryBase)this.listWidgets.get(i)).onMouseReleased(click);
        }
        return super.onMouseReleased(click);
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (mouseX >= (double)this.posX && mouseX <= (double)(this.posX + this.browserWidth) && mouseY >= (double)this.posY && mouseY <= (double)(this.posY + this.browserHeight)) {
            this.offsetSelectionOrScrollbar(verticalAmount < 0.0 ? 3 : -3, false);
            return true;
        }
        return false;
    }

    protected boolean onMouseClickedSearchBar(class_11909 click, boolean doubleClick) {
        if (this.widgetSearchBar != null) {
            boolean searchOpenPre = this.widgetSearchBar.isSearchOpen();
            if (this.widgetSearchBar.onMouseClickedImpl(click, doubleClick)) {
                if (this.widgetSearchBar.isSearchOpen() != searchOpenPre) {
                    this.clearSelection();
                    this.refreshBrowserEntries();
                    this.resetScrollbarPosition();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onKeyTyped(class_11908 input) {
        if (this.onKeyTypedSearchBar(input)) {
            return true;
        }
        if (this.allowKeyboardNavigation) {
            if (input.comp_4795() == 265) {
                this.offsetSelectionOrScrollbar(-1, true);
            } else if (input.comp_4795() == 264) {
                this.offsetSelectionOrScrollbar(1, true);
            } else if (input.comp_4795() == 266) {
                this.offsetSelectionOrScrollbar(-this.maxVisibleBrowserEntries / 2, true);
            } else if (input.comp_4795() == 267) {
                this.offsetSelectionOrScrollbar(this.maxVisibleBrowserEntries / 2, true);
            } else if (input.comp_4795() == 268) {
                this.offsetSelectionOrScrollbar(-this.listContents.size(), true);
            } else if (input.comp_4795() == 269) {
                this.offsetSelectionOrScrollbar(this.listContents.size(), true);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onCharTyped(class_11905 input) {
        if (this.onCharTypedSearchBar(input)) {
            return true;
        }
        for (WidgetListEntryBase widget : this.listWidgets) {
            if (!widget.onCharTyped(input)) continue;
            return true;
        }
        return super.onCharTyped(input);
    }

    protected boolean onKeyTypedSearchBar(class_11908 input) {
        if (this.widgetSearchBar != null && this.widgetSearchBar.onKeyTyped(input)) {
            this.clearSelection();
            this.refreshBrowserEntries();
            this.resetScrollbarPosition();
            return true;
        }
        return false;
    }

    protected boolean onCharTypedSearchBar(class_11905 input) {
        if (this.widgetSearchBar != null && this.widgetSearchBar.onCharTyped(input)) {
            this.clearSelection();
            this.refreshBrowserEntries();
            this.resetScrollbarPosition();
            return true;
        }
        return false;
    }

    protected boolean getShouldSortList() {
        return this.shouldSortList;
    }

    protected boolean hasFilter() {
        return this.widgetSearchBar != null && this.widgetSearchBar.hasFilter();
    }

    @Nullable
    public WidgetSearchBar getSearchBarWidget() {
        return this.widgetSearchBar;
    }

    public List<TYPE> getCurrentEntries() {
        return this.listContents;
    }

    protected Collection<TYPE> getAllEntries() {
        return Collections.emptyList();
    }

    protected Comparator<TYPE> getComparator() {
        return null;
    }

    protected void refreshBrowserEntries() {
        this.listContents.clear();
        Collection<TYPE> entries = this.getAllEntries();
        if (this.hasFilter()) {
            this.addFilteredContents(entries);
        } else {
            this.addNonFilteredContents(entries);
        }
        if (this.getShouldSortList()) {
            Collections.sort(this.listContents, this.getComparator());
        }
        this.reCreateListEntryWidgets();
    }

    protected boolean filterMatchesEmptyEntry(TYPE entry) {
        return true;
    }

    protected String getFilterText() {
        return this.widgetSearchBar != null ? this.widgetSearchBar.getFilter() : "";
    }

    protected boolean entryMatchesFilter(TYPE entry, String filterText) {
        List<String> entryStrings = this.getEntryStringsForFilter(entry);
        if (entryStrings.isEmpty()) {
            return this.filterMatchesEmptyEntry(entry);
        }
        return this.matchesFilter(entryStrings, filterText);
    }

    protected boolean matchesFilter(List<String> entryStrings, String filterText) {
        if (filterText.isEmpty()) {
            return true;
        }
        for (String str : entryStrings) {
            if (!this.matchesFilter(str, filterText)) continue;
            return true;
        }
        return false;
    }

    protected boolean matchesFilter(String entryString, String filterText) {
        if (filterText.isEmpty()) {
            return true;
        }
        for (String filter : filterText.split("\\|")) {
            if (!entryString.contains(filter)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getEntryStringsForFilter(TYPE entry) {
        return Collections.emptyList();
    }

    protected void addNonFilteredContents(Collection<TYPE> placements) {
        this.listContents.addAll(placements);
    }

    protected void addFilteredContents(Collection<TYPE> entries) {
        String filterText = this.getFilterText();
        for (TYPE entry : entries) {
            if (!filterText.isEmpty() && !this.entryMatchesFilter(entry, filterText)) continue;
            this.listContents.add(entry);
        }
    }

    @Override
    protected boolean shouldRenderHoverStuff() {
        return true;
    }

    @Override
    public void drawContents(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        WidgetBase hovered = null;
        int scrollbarHeight = this.browserHeight - this.browserEntriesOffsetY - 8;
        int totalHeight = 0;
        for (TYPE listContent : this.listContents) {
            totalHeight += this.getBrowserEntryHeightFor(listContent);
        }
        totalHeight = Math.max(totalHeight, scrollbarHeight);
        int scrollBarX = this.posX + this.browserWidth - 9;
        int scrollBarY = this.browserEntriesStartY + this.browserEntriesOffsetY;
        this.scrollBar.render(drawContext, mouseX, mouseY, partialTicks, scrollBarX, scrollBarY, 8, scrollbarHeight, totalHeight);
        if (this.scrollBar.getValue() != this.lastScrollbarPosition) {
            this.lastScrollbarPosition = this.scrollBar.getValue();
            this.reCreateListEntryWidgets();
        }
        for (WidgetListEntryBase widget : this.listWidgets) {
            Object entry = widget.getEntry();
            boolean isSelected = this.allowMultiSelection ? this.selectedEntries.contains(entry) : entry != null && entry.equals(this.getLastSelectedEntry());
            widget.render(drawContext, mouseX, mouseY, isSelected);
            if (!widget.isMouseOver(mouseX, mouseY)) continue;
            hovered = widget;
        }
        if (this.widgetSearchBar != null) {
            this.widgetSearchBar.render(drawContext, mouseX, mouseY, false);
        }
        if (hovered == null && this.widgetSearchBar != null && this.widgetSearchBar.isMouseOver(mouseX, mouseY)) {
            hovered = this.widgetSearchBar;
        }
        this.hoveredWidget = hovered;
    }

    public void setSize(int width, int height) {
        this.totalWidth = width;
        this.totalHeight = height;
        this.browserWidth = width;
        this.browserHeight = height;
        this.browserPaddingX = 3;
        this.browserPaddingY = 4;
        this.browserEntriesStartX = this.posX + this.browserPaddingX;
        this.browserEntriesStartY = this.posY + this.browserPaddingY;
        this.browserEntryWidth = this.browserWidth - 14;
    }

    protected int getBrowserEntryHeightFor(@Nullable TYPE type) {
        return this.browserEntryHeight;
    }

    protected void reCreateListEntryWidgets() {
        this.listWidgets.clear();
        this.maxVisibleBrowserEntries = 0;
        int numEntries = this.listContents.size();
        int usableHeight = this.browserHeight - this.browserPaddingY - this.browserEntriesOffsetY;
        int usedHeight = 0;
        int x = this.posX + 2;
        int y = this.posY + 4 + this.browserEntriesOffsetY;
        int index = this.scrollBar.getValue();
        WIDGET widget = this.createHeaderWidget(x, y, index, usableHeight, usedHeight);
        if (widget != null) {
            this.listWidgets.add(widget);
            usedHeight += ((WidgetBase)widget).getHeight();
            y += ((WidgetBase)widget).getHeight();
        }
        while (index < numEntries && (widget = this.createListEntryWidgetIfSpace(x, y, index, usableHeight, usedHeight)) != null) {
            this.listWidgets.add(widget);
            ++this.maxVisibleBrowserEntries;
            usedHeight += ((WidgetBase)widget).getHeight();
            y += ((WidgetBase)widget).getHeight();
            ++index;
        }
        this.scrollBar.setMaxValue(this.listContents.size() - this.maxVisibleBrowserEntries);
    }

    @Nullable
    protected WIDGET createListEntryWidgetIfSpace(int x, int y, int listIndex, int usableHeight, int usedHeight) {
        TYPE entry = this.listContents.get(listIndex);
        int height = this.getBrowserEntryHeightFor(entry);
        if (usedHeight + height > usableHeight) {
            return null;
        }
        return this.createListEntryWidget(x, y, listIndex, (listIndex & 1) != 0, entry);
    }

    @Nullable
    protected WIDGET createHeaderWidget(int x, int y, int listIndexStart, int usableHeight, int usedHeight) {
        return null;
    }

    public void refreshEntries() {
        this.refreshBrowserEntries();
    }

    protected abstract WIDGET createListEntryWidget(int var1, int var2, int var3, boolean var4, TYPE var5);

    @Nullable
    public TYPE getLastSelectedEntry() {
        return this.lastSelectedEntry;
    }

    public Set<TYPE> getSelectedEntries() {
        return this.selectedEntries;
    }

    protected boolean onEntryClicked(@Nullable TYPE entry, int index) {
        this.setLastSelectedEntry(entry, index);
        return true;
    }

    public void setLastSelectedEntry(@Nullable TYPE entry, int index) {
        this.lastSelectedEntry = entry;
        this.lastSelectedEntryIndex = index;
        if (this.allowMultiSelection && entry != null) {
            if (this.selectedEntries.contains(entry)) {
                this.selectedEntries.remove(entry);
            } else {
                this.selectedEntries.add(entry);
            }
        }
        if (entry != null && this.selectionListener != null) {
            this.selectionListener.onSelectionChange(entry);
        }
    }

    public void clearSelection() {
        this.setLastSelectedEntry(null, -1);
    }

    public void clearAllSelections() {
        this.clearSelection();
        this.selectedEntries.clear();
    }

    protected void offsetSelectionOrScrollbar(int amount, boolean changeSelection) {
        if (!changeSelection) {
            this.scrollBar.offsetValue(amount);
        } else if (this.lastSelectedEntryIndex >= 0 && this.listContents.size() > 0) {
            int index = class_3532.method_15340((int)(this.lastSelectedEntryIndex + amount), (int)0, (int)(this.listContents.size() - 1));
            if (index != this.lastSelectedEntryIndex) {
                if (index < this.scrollBar.getValue() || index >= this.scrollBar.getValue() + this.maxVisibleBrowserEntries) {
                    this.scrollBar.offsetValue(index - this.lastSelectedEntryIndex);
                }
                this.setLastSelectedEntry(this.listContents.get(index), index);
            }
        } else {
            int index;
            if (this.lastSelectedEntryIndex >= 0) {
                this.scrollBar.offsetValue(amount);
            }
            if ((index = this.scrollBar.getValue()) >= 0 && index < this.listContents.size()) {
                this.setLastSelectedEntry(this.listContents.get(index), index);
            }
        }
        this.reCreateListEntryWidgets();
    }

    public void resetScrollbarPosition() {
        this.scrollBar.setValue(0);
    }

    public GuiScrollBar getScrollbar() {
        return this.scrollBar;
    }
}

