/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.wrapper;

import com.hyfata.najoan.koreanpatch.process.HangulProcessor;
import com.hyfata.najoan.koreanpatch.process.keyboard.KeyboardLayout;
import com.hyfata.najoan.koreanpatch.util.HangulUtil;
import com.hyfata.najoan.koreanpatch.wrapper.InterfaceIMEWrapper;
import com.hyfata.najoan.koreanpatch.wrapper.handler.IMEWrapperHandler;
import me.shedaniel.rei.api.client.gui.widgets.TextField;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class WrapperREITextField
implements InterfaceIMEWrapper {
    private final TextField accessor;

    public WrapperREITextField(TextField accessor) {
        this.accessor = accessor;
    }

    @Override
    public int getCursor() {
        return this.accessor.getCursor();
    }

    @Override
    public void writeText(String str) {
        this.accessor.addText(str);
    }

    @Override
    public void modifyText(char ch) {
        Object text = this.accessor.getText();
        text = ((String)text).substring(0, ((String)text).length() - 1) + ch;
        this.accessor.setText((String)text);
    }

    public boolean onBackspaceKeyPressed() {
        if (!this.accessor.getSelectedText().isEmpty()) {
            return false;
        }
        int cursorPosition = this.accessor.getCursor();
        return IMEWrapperHandler.onBackspaceKeyPressed(this, cursorPosition, this.accessor.getText());
    }

    public boolean onHangulCharTyped(int keyCode, int modifiers) {
        return IMEWrapperHandler.onHangulCharTyped(this, keyCode, modifiers, this.accessor.getText(), this.accessor.getSelectedText().isEmpty());
    }

    public void typedTextField(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        int qwertyIndex = KeyboardLayout.INSTANCE.getQwertyIndexCodePoint(chr);
        if (qwertyIndex == -1) {
            KeyboardLayout.INSTANCE.assemblePosition = -1;
            return;
        }
        if (!this.accessor.method_25370()) {
            cir.setReturnValue((Object)Boolean.FALSE);
            return;
        }
        cir.setReturnValue((Object)Boolean.TRUE);
        char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
        if (this.getCursor() == 0 || !HangulProcessor.isHangulCharacter(curr) || !this.onHangulCharTyped(chr, modifiers)) {
            this.writeText(String.valueOf(HangulUtil.getFixedHangulChar(modifiers, chr, curr)));
            KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.getCursor() : -1;
        }
    }
}

