/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.nbt.INbtEntityInvoker;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import fi.dy.masa.malilib.util.nbt.NbtView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10586;
import net.minecraft.class_10588;
import net.minecraft.class_10630;
import net.minecraft.class_10686;
import net.minecraft.class_10689;
import net.minecraft.class_10731;
import net.minecraft.class_10733;
import net.minecraft.class_10756;
import net.minecraft.class_10758;
import net.minecraft.class_10823;
import net.minecraft.class_12319;
import net.minecraft.class_12321;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1438;
import net.minecraft.class_1440;
import net.minecraft.class_1453;
import net.minecraft.class_1462;
import net.minecraft.class_1463;
import net.minecraft.class_1474;
import net.minecraft.class_1501;
import net.minecraft.class_1535;
import net.minecraft.class_156;
import net.minecraft.class_1702;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1916;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3441;
import net.minecraft.class_3850;
import net.minecraft.class_4019;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5135;
import net.minecraft.class_5148;
import net.minecraft.class_5149;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5762;
import net.minecraft.class_5955;
import net.minecraft.class_6880;
import net.minecraft.class_7106;
import net.minecraft.class_7375;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9346;
import net.minecraft.class_9347;
import net.minecraft.class_9817;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class NbtEntityUtils {
    public static class_2487 invokeEntityNbtDataNoPassengers(class_1297 entity, int id) {
        return ((INbtEntityInvoker)entity).malilib$getNbtDataWithId(id).orElseGet(class_2487::new);
    }

    @Nullable
    public static class_1299<?> getEntityTypeFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("id")) {
            return class_7923.field_41177.method_17966(class_2960.method_12829((String)nbt.method_68564("id", ""))).orElse(null);
        }
        return null;
    }

    public class_2487 setEntityTypeToNbt(class_1299<?> type, @Nullable class_2487 nbtIn) {
        class_2487 nbt = new class_2487();
        class_2960 id = class_1299.method_5890(type);
        if (id != null) {
            if (nbtIn != null) {
                nbtIn.method_10582("id", id.toString());
                return nbtIn;
            }
            nbt.method_10582("id", id.toString());
        }
        return nbt;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    class_6880.class_6883<@NotNull class_1299<?>> getEntityTypeEntry(class_2960 id, @Nonnull class_5455 registry) {
        try {
            return (class_6880.class_6883)registry.method_30530(class_7923.field_41177.method_46765()).method_10223(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static class_5131 getAttributesFromNbt(@Nonnull class_2487 nbt) {
        class_1299<?> type = NbtEntityUtils.getEntityTypeFromNbt(nbt);
        if (type != null && nbt.method_10545("attributes")) {
            class_5131 container = new class_5131(class_5135.method_26873(type));
            container.method_71381((List)class_1324.class_11345.field_60358.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_68569("attributes")).getPartialOrThrow());
            return container;
        }
        return null;
    }

    public static double getAttributeBaseValueFromNbt(@Nonnull class_2487 nbt, class_6880<@NotNull class_1320> attribute) {
        class_5131 attributes = NbtEntityUtils.getAttributesFromNbt(nbt);
        if (attributes != null) {
            return attributes.method_26856(attribute);
        }
        return -1.0;
    }

    public static double getAttributeValueFromNbt(@Nonnull class_2487 nbt, class_6880<@NotNull class_1320> attribute) {
        class_5131 attributes = NbtEntityUtils.getAttributesFromNbt(nbt);
        if (attributes != null) {
            return attributes.method_26852(attribute);
        }
        return -1.0;
    }

    public static Pair<Double, Double> getHealthFromNbt(@Nonnull class_2487 nbt) {
        double maxHealth;
        double health = 0.0;
        if (nbt.method_10545("Health")) {
            health = nbt.method_66563("Health", 0.0f);
        }
        if ((maxHealth = NbtEntityUtils.getAttributeValueFromNbt(nbt, (class_6880<class_1320>)class_5134.field_23716)) < 0.0) {
            maxHealth = 20.0;
        }
        return Pair.of((Object)health, (Object)maxHealth);
    }

    public static Pair<Double, Double> getSpeedAndJumpStrengthFromNbt(@Nonnull class_2487 nbt) {
        class_5131 container = NbtEntityUtils.getAttributesFromNbt(nbt);
        double moveSpeed = 0.0;
        double jumpStrength = 0.0;
        if (container != null) {
            moveSpeed = container.method_26852(class_5134.field_23719);
            jumpStrength = container.method_26852(class_5134.field_23728);
        }
        return Pair.of((Object)moveSpeed, (Object)jumpStrength);
    }

    @Nullable
    public static class_2561 getCustomNameFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10545("CustomName")) {
            return nbt.method_67492("CustomName", class_8824.field_46597, (DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560)).orElse(null);
        }
        return null;
    }

    public static class_2487 setCustomNameToNbt(@Nonnull class_2561 name, @Nonnull class_5455 registry, @Nullable class_2487 nbtIn, String key) {
        class_2487 nbt;
        class_2487 class_24872 = nbt = nbtIn != null ? nbtIn.method_10553() : new class_2487();
        if (key == null || key.isEmpty()) {
            key = "CustomName";
        }
        nbt.method_67493(key, class_8824.field_46597, (DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)name);
        return nbt;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Map<class_6880<@NotNull class_1291>, class_1293> getActiveStatusEffectsFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        @NotNull HashMap statusEffects = Maps.newHashMap();
        if (nbt.method_10545("active_effects")) {
            List list = nbt.method_67492("active_effects", class_1293.field_48821.listOf(), (DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560)).orElse(List.of());
            for (class_1293 instance : list) {
                statusEffects.put(instance.method_5579(), instance);
            }
        }
        return statusEffects;
    }

    @Nullable
    public static class_10630 getEquipmentSlotsFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10545("equipment")) {
            return class_10630.field_55943.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)Objects.requireNonNull(nbt.method_10580("equipment"))).result().orElse(null);
        }
        return null;
    }

    @Nullable
    public static class_2520 setEquipmentSlotsToNbt(@Nonnull class_10630 equipment, @Nonnull class_5455 registry) {
        try {
            return (class_2520)class_10630.field_55943.encodeStart((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)equipment).getOrThrow();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("setEquipmentSlotsToNbt(): Failed to parse Equipment Slots Object; {}", (Object)err.getMessage());
            return null;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static class_2371<@NotNull class_1799> getHandItemsFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        @NotNull class_2371 list = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        class_10630 equipment = NbtEntityUtils.getEquipmentSlotsFromNbt(nbt, registry);
        if (equipment != null) {
            class_1799 mainHand = equipment.method_66659(class_1304.field_6173);
            class_1799 offHand = equipment.method_66659(class_1304.field_6171);
            if (mainHand != null && !mainHand.method_7960()) {
                list.set(0, (Object)mainHand.method_7972());
            }
            if (offHand != null && !offHand.method_7960()) {
                list.set(1, (Object)offHand.method_7972());
            }
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static class_2371<@NotNull class_1799> getHumanoidArmorFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        @NotNull class_2371 list = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        class_10630 equipment = NbtEntityUtils.getEquipmentSlotsFromNbt(nbt, registry);
        if (equipment != null) {
            class_1799 head = equipment.method_66659(class_1304.field_6169);
            class_1799 chest = equipment.method_66659(class_1304.field_6174);
            class_1799 legs = equipment.method_66659(class_1304.field_6172);
            class_1799 feet = equipment.method_66659(class_1304.field_6166);
            if (head != null && !head.method_7960()) {
                list.set(0, (Object)head.method_7972());
            }
            if (chest != null && !chest.method_7960()) {
                list.set(1, (Object)chest.method_7972());
            }
            if (legs != null && !legs.method_7960()) {
                list.set(2, (Object)legs.method_7972());
            }
            if (feet != null && !feet.method_7960()) {
                list.set(3, (Object)feet.method_7972());
            }
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static class_2371<@NotNull class_1799> getHorseEquipmentFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        @NotNull class_2371 list = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        class_10630 equipment = NbtEntityUtils.getEquipmentSlotsFromNbt(nbt, registry);
        if (equipment != null) {
            class_1799 bodyArmor = equipment.method_66659(class_1304.field_48824);
            class_1799 saddle = equipment.method_66659(class_1304.field_55946);
            if (bodyArmor != null && !bodyArmor.method_7960()) {
                list.set(0, (Object)bodyArmor.method_7972());
            }
            if (saddle != null && !saddle.method_7960()) {
                list.set(1, (Object)saddle.method_7972());
            }
        }
        return list;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static class_2371<@NotNull class_1799> getAllEquipmentFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        @NotNull class_2371 list = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
        class_10630 equipment = NbtEntityUtils.getEquipmentSlotsFromNbt(nbt, registry);
        if (equipment != null) {
            class_1799 mainHand = equipment.method_66659(class_1304.field_6173);
            class_1799 offHand = equipment.method_66659(class_1304.field_6171);
            class_1799 head = equipment.method_66659(class_1304.field_6169);
            class_1799 chest = equipment.method_66659(class_1304.field_6174);
            class_1799 legs = equipment.method_66659(class_1304.field_6172);
            class_1799 feet = equipment.method_66659(class_1304.field_6166);
            class_1799 bodyArmor = equipment.method_66659(class_1304.field_48824);
            class_1799 saddle = equipment.method_66659(class_1304.field_55946);
            if (mainHand != null && !mainHand.method_7960()) {
                list.set(0, (Object)mainHand.method_7972());
            }
            if (offHand != null && !offHand.method_7960()) {
                list.set(1, (Object)offHand.method_7972());
            }
            if (head != null && !head.method_7960()) {
                list.set(2, (Object)head.method_7972());
            }
            if (chest != null && !chest.method_7960()) {
                list.set(3, (Object)chest.method_7972());
            }
            if (legs != null && !legs.method_7960()) {
                list.set(4, (Object)legs.method_7972());
            }
            if (feet != null && !feet.method_7960()) {
                list.set(5, (Object)feet.method_7972());
            }
            if (bodyArmor != null && !bodyArmor.method_7960()) {
                list.set(6, (Object)bodyArmor.method_7972());
            }
            if (saddle != null && !saddle.method_7960()) {
                list.set(7, (Object)saddle.method_7972());
            }
        }
        return list;
    }

    public static Pair<UUID, Boolean> getTamableOwner(@Nonnull class_2487 nbt) {
        UUID owner = class_156.field_25140;
        boolean sitting = false;
        if (nbt.method_10545("Owner")) {
            owner = NbtUtils.getUUIDCodec(nbt, "Owner");
        }
        if (nbt.method_10545("Sitting")) {
            sitting = nbt.method_10577("Sitting").orElse(false);
        }
        return Pair.of((Object)owner, (Object)sitting);
    }

    public static Pair<Integer, Integer> getAgeFromNbt(@Nonnull class_2487 nbt) {
        int breedingAge = 0;
        int forcedAge = 0;
        if (nbt.method_10545("Age")) {
            breedingAge = nbt.method_68083("Age", 0);
        }
        if (nbt.method_10545("ForcedAge")) {
            forcedAge = nbt.method_68083("ForcedAge", 0);
        }
        return Pair.of((Object)breedingAge, (Object)forcedAge);
    }

    @Nullable
    public static class_1916 getTradeOffersFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10545("Offers")) {
            return nbt.method_67492("Offers", class_1916.field_48850, (DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560)).orElse(null);
        }
        return null;
    }

    @Nullable
    public static class_3850 getVillagerDataFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("VillagerData")) {
            return nbt.method_67491("VillagerData", class_3850.field_24669).orElse(null);
        }
        return null;
    }

    public static Pair<Integer, UUID> getZombieConversionTimerFromNbt(@Nonnull class_2487 nbt) {
        int timer = -1;
        UUID player = class_156.field_25140;
        if (nbt.method_10545("ConversionTime")) {
            timer = nbt.method_68083("ConversionTime", -1);
        }
        if (nbt.method_10545("ConversionPlayer")) {
            player = NbtUtils.getUUIDCodec(nbt, "ConversionPlayer");
        }
        return Pair.of((Object)timer, (Object)player);
    }

    public static Pair<Integer, Integer> getDrownedConversionTimerFromNbt(@Nonnull class_2487 nbt) {
        int drowning = -1;
        int inWater = -1;
        if (nbt.method_10545("DrownedConversionTime")) {
            drowning = nbt.method_68083("DrownedConversionTime", -1);
        }
        if (nbt.method_10545("InWaterTime")) {
            inWater = nbt.method_68083("InWaterTime", -1);
        }
        return Pair.of((Object)drowning, (Object)inWater);
    }

    public static int getStrayConversionTimeFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("StrayConversionTime")) {
            return nbt.method_68083("StrayConversionTime", -1);
        }
        return -1;
    }

    @Nullable
    public static class_9817.class_9818 getLeashDataFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("leash")) {
            return nbt.method_67491("leash", class_9817.class_9818.field_56648).orElse(null);
        }
        return null;
    }

    public static Pair<class_1440.class_1443, class_1440.class_1443> getPandaGenesFromNbt(@Nonnull class_2487 nbt) {
        class_1440.class_1443 mainGene = null;
        class_1440.class_1443 hiddenGene = null;
        if (nbt.method_10545("MainGene")) {
            mainGene = nbt.method_67491("MainGene", class_1440.class_1443.field_41673).orElse(class_1440.class_1443.field_6788);
        }
        if (nbt.method_10545("HiddenGene")) {
            hiddenGene = nbt.method_67491("HiddenGene", class_1440.class_1443.field_41673).orElse(class_1440.class_1443.field_6788);
        }
        return Pair.of(mainGene, hiddenGene);
    }

    public static Pair<class_2350, class_2350> getItemFrameDirectionsFromNbt(@Nonnull class_2487 nbt) {
        class_2350 facing = null;
        class_2350 rotation = null;
        if (nbt.method_10545("Facing")) {
            facing = NbtUtils.readDirectionFromTag(nbt, "Facing");
        }
        if (nbt.method_10545("ItemRotation")) {
            rotation = class_2350.method_10143((int)nbt.method_68562("ItemRotation", (byte)0));
        }
        return Pair.of((Object)facing, rotation);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Pair<class_2350, class_1535> getPaintingDataFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_2350 facing = null;
        @NotNull class_6880 variant = null;
        if (nbt.method_10545("facing")) {
            facing = NbtUtils.readDirectionFromTag(nbt, "facing");
        }
        if (nbt.method_10545("variant")) {
            variant = class_1535.field_51597.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).resultOrPartial().orElse(null);
        }
        return Pair.of((Object)facing, variant != null ? (class_1535)variant.comp_349() : null);
    }

    @Nullable
    public static class_5762.class_5767 getAxolotlVariantFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("Variant")) {
            return nbt.method_67491("Variant", class_5762.class_5767.field_56659).orElse(class_5762.class_5767.field_28341);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Pair<class_5321<@NotNull class_7375>, class_1767> getCatVariantFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        @NotNull class_5321 variantKey = null;
        class_1767 collar = null;
        if (nbt.method_10545("variant")) {
            @NotNull Optional variant = class_7375.field_55959.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).resultOrPartial();
            variantKey = variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_10686.field_56260);
        }
        if (nbt.method_10545("CollarColor")) {
            collar = nbt.method_67491("CollarColor", class_1767.field_56666).orElse(class_1767.field_7964);
        }
        if (variantKey == null) {
            variantKey = class_10686.field_56260;
        }
        if (collar == null) {
            collar = class_1767.field_7964;
        }
        return Pair.of((Object)variantKey, (Object)collar);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_10756> getChickenVariantFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10545("variant")) {
            @NotNull Optional variant = class_10756.field_56540.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).resultOrPartial();
            return variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_10758.field_56550);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_10731> getCowVariantFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10545("variant")) {
            @NotNull Optional variant = class_10731.field_56427.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).resultOrPartial();
            return variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_10733.field_56438);
        }
        return null;
    }

    @Nullable
    public static class_1438.class_4053 getMooshroomVariantFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("Type")) {
            return nbt.method_67491("Type", class_1438.class_4053.field_41549).orElse(class_1438.class_4053.field_18109);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_7106> getFrogVariantFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10545("variant")) {
            @NotNull Optional variant = class_7106.field_55961.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).resultOrPartial();
            return variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_10689.field_56278);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_12319> getZombieNautilusVariantFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10545("variant")) {
            @NotNull Optional variant = class_12319.field_64363.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).resultOrPartial();
            return variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_12321.field_64372);
        }
        return null;
    }

    public static Pair<class_5149, class_5148> getHorseVariantFromNbt(@Nonnull class_2487 nbt) {
        class_5149 color = null;
        class_5148 marking = null;
        if (nbt.method_10545("Variant")) {
            int variant = nbt.method_68083("Variant", 0);
            color = class_5149.method_27083((int)(variant & 0xFF));
            marking = class_5148.method_27080((int)((variant & 0xFF00) >> 8));
        }
        return Pair.of(color, marking);
    }

    @Nullable
    public static class_1453.class_7989 getParrotVariantFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("Variant")) {
            return nbt.method_67491("Variant", class_1453.class_7989.field_56653).orElse(class_1453.class_7989.field_41550);
        }
        return null;
    }

    @Nullable
    public static class_1474.class_1475 getFishVariantFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("Variant")) {
            class_1474.class_7992 class_79922 = nbt.method_67491("Variant", class_1474.class_7992.field_49236).orElse(class_1474.field_55968);
        } else if (nbt.method_10545("BucketVariantTag")) {
            return class_1474.class_1475.method_47868((int)(nbt.method_68083("BucketVariantTag", 0) & 0xFFFF));
        }
        return null;
    }

    @Nullable
    public static class_1474.class_1475 getFishPatternFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("Variant")) {
            return nbt.method_67491("Variant", class_1474.class_7992.field_49236).orElse(class_1474.field_55968).comp_1177();
        }
        if (nbt.method_10545("BucketVariantTag")) {
            return class_1474.class_1475.method_47868((int)(nbt.method_68083("BucketVariantTag", 0) & 0xFFFF));
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Pair<class_5321<@NotNull class_9346>, class_1767> getWolfVariantFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        @NotNull class_5321 variantKey = null;
        class_1767 collar = null;
        if (nbt.method_10545("variant")) {
            @NotNull Optional variant = class_9346.field_49980.fieldOf("variant").codec().parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).resultOrPartial();
            variantKey = variant.map(entry -> (class_5321)entry.method_40230().orElseThrow()).orElse(class_9347.field_51588);
        }
        if (nbt.method_10545("CollarColor")) {
            collar = nbt.method_67491("CollarColor", class_1767.field_56666).orElse(class_1767.field_7964);
        }
        if (variantKey == null) {
            variantKey = class_9347.field_51588;
        }
        if (collar == null) {
            collar = class_1767.field_7964;
        }
        return Pair.of((Object)variantKey, (Object)collar);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_10823> getWolfSoundTypeFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10545("sound_variant")) {
            try {
                // Could not load outer class - annotation placement on inner may be incorrect
                @NotNull class_6880.class_6883 soundVariant = registry.method_30530(class_7924.field_57110).method_10223(Objects.requireNonNull(class_2960.method_12829((String)nbt.method_68564("sound_variant", "")))).orElse(null);
                if (soundVariant != null) {
                    return soundVariant.method_40237();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static class_1767 getSheepColorFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("Color")) {
            return nbt.method_67491("Color", class_1767.field_56666).orElse(class_1767.field_7952);
        }
        return null;
    }

    @Nullable
    public static class_1463.class_7990 getRabbitTypeFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("RabbitType")) {
            return nbt.method_67491("RabbitType", class_1463.class_7990.field_56654).orElse(class_1463.class_7990.field_41561);
        }
        return null;
    }

    public static Pair<class_1501.class_7993, Integer> getLlamaTypeFromNbt(@Nonnull class_2487 nbt) {
        class_1501.class_7993 variant = null;
        int strength = -1;
        if (nbt.method_10545("Variant")) {
            variant = nbt.method_67491("Variant", class_1501.class_7993.field_56660).orElse(class_1501.class_7993.field_41586);
        }
        if (nbt.method_10545("Strength")) {
            strength = nbt.method_68083("Strength", -1);
        }
        return Pair.of((Object)variant, (Object)strength);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static class_5321<@NotNull class_10586> getPigVariantFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        if (nbt.method_10545("variant")) {
            try {
                @NotNull Optional opt = registry.method_30530(class_7924.field_55883).method_10223(Objects.requireNonNull(class_2960.method_12829((String)nbt.method_68564("variant", ""))));
                return opt.map(class_6880.class_6883::method_40237).orElse(class_10588.field_55699);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static class_4019.class_4039 getFoxVariantFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("Type")) {
            return nbt.method_67491("Type", (Codec)class_4019.class_4039.field_41548).orElse(class_4019.class_4039.field_17996);
        }
        return null;
    }

    @Nullable
    public static class_1462.class_9869 getSalmonVariantFromNbt(@Nonnull class_2487 nbt) {
        if (nbt.method_10545("type")) {
            return nbt.method_67491("type", (Codec)class_1462.class_9869.field_52473).orElse(class_1462.class_9869.field_52471);
        }
        return null;
    }

    public static Pair<Integer, Boolean> getDolphinDataFromNbt(@Nonnull class_2487 nbt) {
        boolean hasFish = false;
        int moist = -1;
        if (nbt.method_10545("Moistness")) {
            moist = nbt.method_68083("Moistness", -1);
        }
        if (nbt.method_10545("GotFish")) {
            hasFish = nbt.method_10577("GotFish").orElse(false);
        }
        return Pair.of((Object)moist, (Object)hasFish);
    }

    public static Triple<Integer, Integer, Float> getPlayerExpFromNbt(@Nonnull class_2487 nbt) {
        int level = -1;
        int total = -1;
        float progress = 0.0f;
        if (nbt.method_10545("XpLevel")) {
            level = nbt.method_68083("XpLevel", -1);
        }
        if (nbt.method_10545("XpTotal")) {
            total = nbt.method_68083("XpTotal", -1);
        }
        if (nbt.method_10545("XpP")) {
            progress = nbt.method_66563("XpP", 0.0f);
        }
        return Triple.of((Object)level, (Object)total, (Object)Float.valueOf(progress));
    }

    @Nullable
    public static class_1702 getPlayerHungerFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_1702 hunger = null;
        if (nbt.method_10545("foodLevel")) {
            hunger = new class_1702();
            NbtView view = NbtView.getReader(nbt, registry);
            hunger.method_7584(view.getReader());
        }
        return hunger;
    }

    @Nullable
    public static class_3441 getPlayerRecipeBookFromNbt(@Nonnull class_2487 nbt, @Nonnull class_1863 manager) {
        class_3441 book = null;
        if (nbt.method_10545("recipeBook")) {
            book = new class_3441((arg_0, arg_1) -> ((class_1863)manager).method_64679(arg_0, arg_1));
            book.method_71343((class_3441.class_11328)class_3441.class_11328.field_60346.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_68568("recipeBook")).getOrThrow(), key -> manager.method_8130(key).isPresent());
        }
        return book;
    }

    public static Pair<class_2338, Integer> getHomePosFromNbt(@Nonnull class_2487 nbt) {
        class_2338 pos = class_2338.field_10980;
        int radius = -1;
        if (nbt.method_10545("home_pos")) {
            pos = nbt.method_67491("home_pos", class_2338.field_25064).orElse(class_2338.field_10980);
        }
        if (nbt.method_10545("home_radius")) {
            radius = nbt.method_68083("home_radius", -1);
        }
        return Pair.of((Object)pos, (Object)radius);
    }

    public static Pair<class_5955.class_5811, Long> getWeatheringDataFromNbt(@Nonnull class_2487 nbt) {
        class_5955.class_5811 level = class_5955.class_5811.field_28704;
        long age = -1L;
        if (nbt.method_10545("weather_state")) {
            level = nbt.method_67491("weather_state", class_5955.class_5811.field_46493).orElse(class_5955.class_5811.field_28704);
        }
        if (nbt.method_10545("next_weather_age")) {
            age = nbt.method_68080("next_weather_age", -1L);
        }
        return Pair.of((Object)level, (Object)age);
    }
}

