/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.camera;

import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineContext;
import fi.dy.masa.minihud.util.SpeedUnits;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_3532;

public abstract class InfoLineRotationYawPitchSpeedBase
extends InfoLine {
    private static final String SPEED_KEY = "minihud.info_line.speed_";
    private static final String ROT_YAW_KEY = "minihud.info_line.rotation_yaw";
    private static final String ROT_PITCH_KEY = "minihud.info_line.rotation_pitch";

    public InfoLineRotationYawPitchSpeedBase(InfoToggle type) {
        super(type);
    }

    @Override
    public boolean succeededType() {
        return this.succeeded;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLineContext ctx) {
        if (ctx.world() == null || ctx.ent() == null) {
            return null;
        }
        SpeedUnits speedUnits = (SpeedUnits)Configs.Generic.SPEED_UNITS.getOptionListValue();
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        String pre = "";
        StringBuilder str = new StringBuilder(128);
        if (InfoToggle.ROTATION_YAW.getBooleanValue()) {
            str.append(this.qt(ROT_YAW_KEY, Float.valueOf(class_3532.method_15393((float)ctx.ent().method_36454()))));
            pre = " / ";
        }
        if (InfoToggle.ROTATION_PITCH.getBooleanValue()) {
            str.append(pre).append(this.qt(ROT_PITCH_KEY, Float.valueOf(class_3532.method_15393((float)ctx.ent().method_36455()))));
            pre = " / ";
        }
        if (InfoToggle.SPEED.getBooleanValue()) {
            double dx = ctx.ent().method_23317() - ctx.ent().field_6038;
            double dy = ctx.ent().method_23318() - ctx.ent().field_5971;
            double dz = ctx.ent().method_23321() - ctx.ent().field_5989;
            double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            str.append(pre).append(this.qt(SPEED_KEY + speedUnits.suffix, speedUnits.convert(dist * 20.0)));
        }
        list.add(this.of(str.toString()));
        this.succeeded = true;
        return list;
    }
}

