/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.world;

import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineContext;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1937;

public class InfoLineTimeWorldFormatted
extends InfoLine {
    private static final String TIME_KEY = "minihud.info_line";

    public InfoLineTimeWorldFormatted(InfoToggle type) {
        super(type);
    }

    public InfoLineTimeWorldFormatted() {
        this(InfoToggle.TIME_WORLD_FORMATTED);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLineContext ctx) {
        if (this.getClientWorld() == null) {
            return null;
        }
        return this.parseWorld(ctx.world() == null ? this.getClientWorld() : ctx.world());
    }

    @Override
    public List<InfoLine.Entry> parseWorld(@Nonnull class_1937 world) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        try {
            long timeDay = world.method_8532();
            long day = (int)(timeDay / 24000L);
            int dayTicks = (int)(timeDay % 24000L);
            int hour = (dayTicks / 1000 + 6) % 24;
            int min = (int)((double)dayTicks / 16.666666) % 60;
            int sec = (int)((double)dayTicks / 0.277777) % 60;
            int minIrl = dayTicks / 1200 % 20;
            int secIrl = dayTicks / 20 % 60;
            int moonNumber = (int)day % 8;
            String moon = moonNumber > 7 ? this.qt("minihud.info_line.invalid_value", new Object[0]) : this.qt("minihud.info_line.time_world_formatted.moon_" + moonNumber, new Object[0]);
            String str = Configs.Generic.DATE_FORMAT_MINECRAFT.getStringValue();
            str = str.replace("{DAY}", String.format("%d", day));
            str = str.replace("{DAY_1}", String.format("%d", day + 1L));
            str = str.replace("{HOUR}", String.format("%02d", hour));
            str = str.replace("{MIN}", String.format("%02d", min));
            str = str.replace("{SEC}", String.format("%02d", sec));
            str = str.replace("{MINIRL}", String.format("%02d", minIrl));
            str = str.replace("{SECIRL}", String.format("%02d", secIrl));
            str = str.replace("{MOON}", String.format("%s", moon));
            list.add(this.of(str));
        }
        catch (Exception e) {
            list.add(this.translate("minihud.info_line.time.exception", new Object[0]));
        }
        return list;
    }
}

