/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.BaseBlockRangeOverlay;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.ConduitExtra;
import fi.dy.masa.minihud.util.ShapeRenderType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2597;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_9801;

public class OverlayRendererConduitRange
extends BaseBlockRangeOverlay<class_2597> {
    public static final OverlayRendererConduitRange INSTANCE = new OverlayRendererConduitRange();
    private final ShapeRenderType renderType;
    private final LayerRange layerRange;
    private final class_2350.class_2351 quadAxis = class_2350.field_11036.method_10166();
    private boolean combineQuads;
    private Color4f colorLines;
    private final List<Entry> conduits;

    public OverlayRendererConduitRange() {
        super((IConfigBoolean)RendererToggle.OVERLAY_CONDUIT_RANGE, class_2591.field_11902, class_2597.class);
        this.renderType = ShapeRenderType.OUTER_EDGE;
        this.layerRange = new LayerRange(null);
        this.conduits = new ArrayList<Entry>();
        this.useCulling = false;
    }

    @Override
    public String getName() {
        return "ConduitRange";
    }

    @Override
    protected void updateBlockRange(class_1937 world, class_2338 pos, class_2597 be, class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (!be.method_11065()) {
            return;
        }
        this.colorLines = Configs.Colors.CONDUIT_RANGE_OUTLINES.getColor();
        this.combineQuads = Configs.Generic.CONDUIT_RANGE_OVERLAY_COMBINE_QUADS.getBooleanValue();
        this.renderThrough = Configs.Generic.CONDUIT_RANGE_OVERLAY_RENDER_THROUGH.getBooleanValue();
        int range = ((ConduitExtra)be).minihud$getStoredActivatingBlockCount() / 7 * 16;
        if (this.checkIfNeedsUpdate(pos, range)) {
            this.addOrReplaceEntry(this.calculateEach(pos, range));
        }
    }

    private boolean checkIfNeedsUpdate(class_2338 pos, int range) {
        AtomicBoolean matched = new AtomicBoolean(false);
        this.conduits.forEach(entry -> {
            if (entry.pos.equals((Object)pos) && entry.range == range) {
                matched.set(true);
            }
        });
        return !matched.get();
    }

    private Entry calculateEach(class_2338 pos, int range) {
        Entry entry = new Entry(pos, range);
        Consumer<class_2338.class_2339> positionCollector = p -> entry.addPosition(p.method_10063());
        entry.setTest(OverlayRendererConduitRange.getPositionTest(pos, entry.range));
        SphereUtils.collectSpherePositions(positionCollector, entry.getTest(), pos, entry.range);
        if (this.combineQuads) {
            entry.setQuads(SphereUtils.buildSphereShellToQuads(entry.getPositions(), this.quadAxis, entry.getTest(), this.renderType, this.layerRange));
        }
        return entry;
    }

    private void addOrReplaceEntry(Entry entry) {
        AtomicBoolean replaced = new AtomicBoolean(false);
        this.conduits.forEach(e -> {
            if (e.pos.method_10265((class_2382)entry.pos) == 0) {
                e.clear();
                e.range = entry.range;
                e.positions.addAll((LongCollection)entry.getPositions());
                e.setTest(entry.getTest());
                e.setQuads(entry.getQuads());
                replaced.set(true);
            }
        });
        if (!replaced.get()) {
            this.conduits.add(entry);
        }
    }

    @Override
    protected void renderBlockRange(class_1937 world, class_243 cameraPos, class_310 mc, class_3695 profiler) {
        boolean outlines = Configs.Generic.CONDUIT_RANGE_OVERLAY_RENDER_OUTLINES.getBooleanValue();
        this.allocateBuffers(outlines);
        this.renderQuads(cameraPos, mc, profiler);
        if (outlines) {
            this.renderOutlines(cameraPos, mc, profiler);
        }
    }

    @Override
    protected void expireBlockRange(class_2338 pos) {
        for (Entry entry : this.conduits) {
            if (!entry.pos.equals((Object)pos)) continue;
            entry.clear();
            this.conduits.remove(entry);
        }
    }

    @Override
    protected void resetBlockRange() {
        this.conduits.forEach(Entry::clear);
        this.conduits.clear();
    }

    private void renderQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        Color4f color = Configs.Colors.CONDUIT_RANGE_OVERLAY_COLOR.getColor();
        profiler.method_15396("conduit_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:conduit/quads", this.renderThrough ? MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH_OFFSET : MaLiLibPipelines.MINIHUD_SHAPE_OFFSET_NO_CULL);
        this.conduits.forEach(entry -> {
            if (this.combineQuads) {
                RenderUtils.renderQuads(entry.getQuads(), color, 0.0, cameraPos, builder);
            } else {
                RenderUtils.renderCircleBlockPositions(entry.getPositions(), PositionUtils.ALL_DIRECTIONS, entry.getTest(), this.renderType, this.layerRange, color, 0.0, cameraPos, builder);
            }
        });
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererConduitRange#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null || !Configs.Generic.CONDUIT_RANGE_OVERLAY_RENDER_OUTLINES.getBooleanValue()) {
            return;
        }
        profiler.method_15396("conduit_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:conduit/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        this.conduits.forEach(entry -> {
            if (this.combineQuads) {
                RenderUtils.renderQuadLines(entry.getQuads(), this.colorLines, 0.0, cameraPos, this.glLineWidth, builder);
            } else {
                RenderUtils.renderCircleBlockOutlines(entry.getPositions(), PositionUtils.ALL_DIRECTIONS, entry.getTest(), this.renderType, this.layerRange, this.colorLines, 0.0, cameraPos, this.glLineWidth, builder);
            }
        });
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererConduitRange#renderBlockRange(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.resetBlockRange();
    }

    protected static SphereUtils.RingPositionTest getPositionTest(class_2338 centerPos, int range) {
        class_243 center = new class_243((double)centerPos.method_10263() + 0.5, (double)centerPos.method_10264() + 0.5, (double)centerPos.method_10260() + 0.5);
        double squareRange = range * range;
        return (x, y, z, dir) -> SphereUtils.isPositionInsideOrClosestToRadiusOnBlockRing(x, y, z, center, squareRange, class_2350.field_11034);
    }

    public static class Entry {
        public class_2338 pos;
        public int range;
        private final LongOpenHashSet positions;
        @Nullable
        private SphereUtils.RingPositionTest test;
        private final List<SideQuad> quads;

        Entry(class_2338 pos, int range) {
            this.pos = pos;
            this.range = range;
            this.positions = new LongOpenHashSet();
            this.test = null;
            this.quads = new ArrayList<SideQuad>();
        }

        public void addPosition(long pos) {
            this.positions.add(pos);
        }

        public LongOpenHashSet getPositions() {
            return this.positions;
        }

        public void setTest(@Nullable SphereUtils.RingPositionTest test) {
            this.test = test;
        }

        @Nullable
        public SphereUtils.RingPositionTest getTest() {
            return this.test;
        }

        public void setQuads(List<SideQuad> quads) {
            this.quads.clear();
            this.quads.addAll(quads);
        }

        public List<SideQuad> getQuads() {
            return this.quads;
        }

        public void clear() {
            this.positions.clear();
            this.quads.clear();
            this.test = null;
        }
    }
}

