/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import net.minecraft.class_9799;
import net.raphimc.immediatelyfast.ImmediatelyFast;

public class ByteBufferBuilderPool {
    private static final ReferenceList<Entry> FREE = new ReferenceArrayList();
    private static final ReferenceList<Entry> IN_USE = new ReferenceArrayList();
    private static final Reference2ObjectMap<class_9799, Entry> BUFFER_BUILDER_MAPPING = new Reference2ObjectOpenHashMap();

    private ByteBufferBuilderPool() {
    }

    public static class_9799 borrowBufferBuilder() {
        Entry entry;
        RenderSystem.assertOnRenderThread();
        if (FREE.isEmpty()) {
            entry = new Entry(new class_9799(256));
        } else {
            entry = (Entry)FREE.removeFirst();
            if (entry.bufferBuilder.field_52082 == 0L) {
                BUFFER_BUILDER_MAPPING.remove((Object)entry.bufferBuilder);
                entry = new Entry(new class_9799(256));
            }
        }
        IN_USE.add((Object)entry);
        BUFFER_BUILDER_MAPPING.put((Object)entry.bufferBuilder, (Object)entry);
        entry.onBorrow();
        return entry.bufferBuilder;
    }

    public static void returnBufferBuilderSafe(class_9799 bufferBuilder) {
        RenderSystem.assertOnRenderThread();
        Entry entry = (Entry)BUFFER_BUILDER_MAPPING.get((Object)bufferBuilder);
        if (!IN_USE.remove((Object)entry)) {
            return;
        }
        entry.onReturn();
        FREE.addFirst((Object)entry);
    }

    public static int getSize() {
        return FREE.size() + IN_USE.size();
    }

    public static long getAllocatedBytes() {
        long total = 0L;
        for (Entry entry : FREE) {
            total += entry.bufferBuilder.field_52083;
        }
        for (Entry entry : IN_USE) {
            total += entry.bufferBuilder.field_52083;
        }
        return total;
    }

    public static void onEndFrame() {
        if (!IN_USE.isEmpty()) {
            IN_USE.removeIf(entry -> {
                if (entry.inUseOverMultipleFrames) {
                    ImmediatelyFast.LOGGER.warn("!!! Possible memory leak detected!!! A BufferBuilder was not returned to the pool. This is not a bug in ImmediatelyFast.");
                    ImmediatelyFast.LOGGER.warn("Allocation stack trace:");
                    if (entry.allocationStackTrace != null) {
                        for (StackTraceElement element : entry.allocationStackTrace) {
                            ImmediatelyFast.LOGGER.warn("\tat {}", (Object)element.toString());
                        }
                    } else {
                        ImmediatelyFast.LOGGER.warn("\t<No stack trace available. Enable debug_only_detailed_memory_leak_detection in the config to get stack traces>");
                    }
                    return true;
                }
                return false;
            });
            for (Entry entry2 : IN_USE) {
                entry2.inUseOverMultipleFrames = true;
            }
        }
        FREE.removeIf(entry -> {
            if (entry.shouldBeClosed()) {
                entry.bufferBuilder.close();
                BUFFER_BUILDER_MAPPING.remove((Object)entry.bufferBuilder);
                return true;
            }
            return false;
        });
    }

    private static class Entry {
        private final class_9799 bufferBuilder;
        private long lastAccessTime;
        private boolean inUseOverMultipleFrames;
        private StackTraceElement[] allocationStackTrace;

        public Entry(class_9799 bufferBuilder) {
            this.bufferBuilder = bufferBuilder;
            this.lastAccessTime = System.currentTimeMillis();
        }

        public boolean shouldBeClosed() {
            return System.currentTimeMillis() - this.lastAccessTime > 60000L;
        }

        public void onBorrow() {
            this.lastAccessTime = System.currentTimeMillis();
            if (ImmediatelyFast.config.debug_only_detailed_memory_leak_detection) {
                this.allocationStackTrace = Thread.currentThread().getStackTrace();
            }
        }

        public void onReturn() {
            this.bufferBuilder.method_60811();
            this.inUseOverMultipleFrames = false;
            this.allocationStackTrace = null;
        }
    }
}

