/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.poi.fast_portals;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.BitSet;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.caffeinemc.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2806;
import net.minecraft.class_3977;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4157;
import net.minecraft.class_4180;
import net.minecraft.class_4538;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_9820;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_4153.class})
public abstract class PoiManagerMixin
extends class_4180<class_4157, class_4157.class_9865>
implements RegionBasedStorageSectionExtended<class_4157> {
    @Shadow
    @Final
    private LongSet field_20688;
    @Unique
    private final LongSet preloadedCenterChunks = new LongOpenHashSet();
    @Unique
    private int preloadRadius = 0;

    public PoiManagerMixin(class_3977 simpleRegionStorage, Codec<class_4157.class_9865> codec, Function<class_4157, class_4157.class_9865> function, BiFunction<class_4157.class_9865, Runnable, class_4157> biFunction, Function<Runnable, class_4157> function2, class_5455 registryAccess, class_9820 chunkIOErrorReporter, class_5539 levelHeightAccessor) {
        super(simpleRegionStorage, codec, function, biFunction, function2, registryAccess, chunkIOErrorReporter, levelHeightAccessor);
    }

    @Overwrite
    public void method_22439(class_4538 worldView, class_2338 pos, int radius) {
        long chunkPos;
        if (this.preloadRadius != radius) {
            this.preloadedCenterChunks.clear();
            this.preloadRadius = radius;
        }
        if (this.preloadedCenterChunks.contains(chunkPos = class_1923.method_37232((class_2338)pos))) {
            return;
        }
        int chunkX = class_4076.method_18675((int)pos.method_10263());
        int chunkZ = class_4076.method_18675((int)pos.method_10260());
        int chunkRadius = Math.floorDiv(radius, 16);
        long[] sectionsYXPacked = new long[2 * chunkRadius + 1];
        int maxYSectionIndexExclusive = Pos.SectionYIndex.getMaxYSectionIndexExclusive((class_5539)worldView);
        int zMax = chunkZ + chunkRadius;
        for (int z = chunkZ - chunkRadius; z <= zMax; ++z) {
            int loadingChunkCounter = 0;
            int xMax = chunkX + chunkRadius;
            for (int x = chunkX - chunkRadius; x <= xMax; ++x) {
                int lowestSection = this.lithium$getLowestEmptyOrInvalidSection(worldView, x, z);
                if (lowestSection >= maxYSectionIndexExclusive || !this.field_20688.add(class_1923.method_8331((int)x, (int)z))) continue;
                sectionsYXPacked[loadingChunkCounter++] = PoiManagerMixin.packYX(lowestSection, x);
            }
            LongArrays.quickSort((long[])sectionsYXPacked, (int)0, (int)loadingChunkCounter);
            for (int chunkIndex = 0; chunkIndex < loadingChunkCounter; ++chunkIndex) {
                long packedYX = sectionsYXPacked[chunkIndex];
                worldView.method_22342(PoiManagerMixin.unpackX(packedYX), z, class_2806.field_12798);
            }
        }
        this.preloadedCenterChunks.add(chunkPos);
    }

    @Unique
    private static int unpackX(long packedYX) {
        return (int)((packedYX & 0xFFFFFFFFL) + Integer.MIN_VALUE);
    }

    @Unique
    private static long packYX(long y, long x) {
        return y << 32 | x - Integer.MIN_VALUE;
    }

    @Unique
    private int lithium$getLowestEmptyOrInvalidSection(class_4538 worldView, int x, int z) {
        BitSet column = this.lithium$getNonEmptyPOISections(x, z);
        int lowestUnsetSection = column.nextClearBit(0);
        int setSectionIndex = -1;
        while ((setSectionIndex = column.nextSetBit(setSectionIndex + 1)) != -1 && setSectionIndex < lowestUnsetSection) {
            Optional section = this.lithium$getElementAt(class_4076.method_18685((int)x, (int)Pos.SectionYCoord.fromSectionIndex((class_5539)worldView, setSectionIndex), (int)z));
            if (!section.isPresent() || ((class_4157)section.get()).method_22444()) continue;
            return setSectionIndex;
        }
        return lowestUnsetSection;
    }
}

