/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.widgets;

import java.util.Objects;
import net.caffeinemc.mods.sodium.client.gui.ButtonTheme;
import net.caffeinemc.mods.sodium.client.gui.ColorTheme;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jspecify.annotations.Nullable;

public abstract class CenteredFlatWidget
extends AbstractWidget {
    private final boolean isSelectable;
    private final ButtonTheme theme;
    private boolean selected;
    private boolean enabled = true;
    private boolean visible = true;
    private final class_2561 label;
    private final class_2561 subtitle;

    public CenteredFlatWidget(Dim2i dim, class_2561 label, class_2561 subtitle, boolean isSelectable, ColorTheme theme) {
        super(dim);
        this.label = label;
        this.subtitle = subtitle;
        this.isSelectable = isSelectable;
        this.theme = new ButtonTheme(theme, 0x8FFFFFF, -1879048192, 0x40000000);
    }

    public CenteredFlatWidget(Dim2i dim, class_2561 label, boolean isSelectable, ColorTheme theme) {
        this(dim, label, null, isSelectable, theme);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        int backgroundColor;
        if (!this.visible) {
            return;
        }
        this.hovered = this.method_25405(mouseX, mouseY);
        int n = this.hovered ? this.theme.bgHighlight : (backgroundColor = this.selected ? this.theme.bgDefault : this.theme.bgInactive);
        int textColor = this.selected || !this.isSelectable ? this.theme.themeLighter : (this.hovered ? this.theme.theme : this.theme.themeDarker);
        int x1 = this.getX();
        int y1 = this.getY();
        int x2 = this.getLimitX();
        int y2 = this.getLimitY();
        if (this.isSelectable) {
            this.drawRect(graphics, x1, y1, x2, y2, backgroundColor);
        }
        if (this.selected) {
            this.drawRect(graphics, x2 - 3, y1, x2, y2, this.theme.themeLighter);
        }
        int textOffset = this.renderIcon(graphics, textColor);
        if (this.subtitle == null) {
            String string = this.truncateToFitWidth(this.label, textOffset);
            float f = y1;
            int n2 = this.getTextBoxHeight();
            Objects.requireNonNull(this.font);
            this.drawString(graphics, string, x1 + textOffset, (int)Math.ceil(f + (float)(n2 - 9) * 0.5f), textColor);
        } else {
            float center = (float)y1 + (float)this.getTextBoxHeight() * 0.5f;
            String string = this.truncateToFitWidth(this.label, textOffset);
            Objects.requireNonNull(this.font);
            this.drawString(graphics, string, x1 + textOffset, (int)Math.ceil(center - (9.0f + 1.0f)), textColor);
            this.drawString(graphics, this.truncateToFitWidth(this.subtitle, textOffset), x1 + textOffset, (int)Math.ceil(center + 1.0f), textColor);
        }
        if (this.enabled && this.method_25370()) {
            this.drawBorder(graphics, x1, y1, x2, y2, -2147418130);
        }
    }

    protected int getTextBoxHeight() {
        return this.getHeight();
    }

    protected int renderIcon(class_332 graphics, int textColor) {
        return 8;
    }

    private String truncateToFitWidth(class_2561 text, int iconOffset) {
        return this.truncateTextToFit(text.getString(), this.getWidth() - 14 - iconOffset);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (!this.enabled || !this.visible) {
            return false;
        }
        if (event.method_74245() == 0 && this.method_25405(event.comp_4798(), event.comp_4799())) {
            this.doAction();
            return true;
        }
        return false;
    }

    public boolean method_25404(class_11908 event) {
        if (!this.method_25370()) {
            return false;
        }
        if (event.method_74229()) {
            this.doAction();
            return true;
        }
        return false;
    }

    abstract void onAction();

    private void doAction() {
        this.onAction();
        this.playClickSound();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public @Nullable class_8016 method_48205(class_8023 event) {
        if (!this.enabled || !this.visible) {
            return null;
        }
        return super.method_48205(event);
    }
}

