/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.IntConsumer;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPBuildFailureException;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPSortState;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.BSPWorkspace;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.InnerBinaryPartitionBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.InnerFixedDoubleBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.InnerMultiPartitionBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.LeafMultiBSPNode;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.bsp_tree.Partition;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TopoGraphSorting;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.FullTQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.quad.TQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.client.util.MathUtil;
import net.caffeinemc.mods.sodium.client.util.sorting.RadixSort;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector3fc;

abstract class InnerPartitionBSPNode
extends BSPNode {
    private static final int NODE_REUSE_THRESHOLD = 30;
    private static final int MAX_INTERSECTION_ATTEMPTS = 500;
    protected static final int UNALIGNED_AXIS = -1;
    final Vector3fc planeNormal;
    final int axis;
    int[] indexMap;
    int fixedIndexOffset = Integer.MIN_VALUE;
    final NodeReuseData reuseData;
    private static final int INTERVAL_START = 2;
    private static final int INTERVAL_END = 0;
    private static final int INTERVAL_SIDE = 1;

    InnerPartitionBSPNode(NodeReuseData reuseData, int axis) {
        this.planeNormal = ModelQuadFacing.ALIGNED_NORMALS[axis];
        this.axis = axis;
        this.reuseData = reuseData;
    }

    InnerPartitionBSPNode(NodeReuseData reuseData, Vector3fc planeNormal) {
        this.planeNormal = planeNormal;
        this.axis = -1;
        this.reuseData = reuseData;
    }

    abstract void addPartitionPlanes(BSPWorkspace var1);

    static NodeReuseData prepareNodeReuse(BSPWorkspace workspace, IntArrayList indexes, int depth) {
        if (workspace.prepareNodeReuse && depth == 1 && indexes.size() > 30) {
            float[][] quadExtents = new float[indexes.size()][];
            int maxIndex = -1;
            for (int i = 0; i < indexes.size(); ++i) {
                int index = indexes.getInt(i);
                TQuad quad = (TQuad)workspace.get(index);
                float[] extents = quad.getExtents();
                quadExtents[i] = extents;
                maxIndex = Math.max(maxIndex, index);
            }
            return new NodeReuseData(quadExtents, BSPSortState.compressIndexes(indexes, false), indexes.size(), maxIndex);
        }
        return null;
    }

    static InnerPartitionBSPNode attemptNodeReuse(BSPWorkspace workspace, IntArrayList newIndexes, InnerPartitionBSPNode oldNode) {
        if (oldNode == null) {
            return null;
        }
        oldNode.indexMap = null;
        oldNode.fixedIndexOffset = Integer.MIN_VALUE;
        NodeReuseData reuseData = oldNode.reuseData;
        if (reuseData == null) {
            return null;
        }
        float[][] oldExtents = reuseData.quadExtents;
        if (oldExtents.length != newIndexes.size()) {
            return null;
        }
        for (int i = 0; i < newIndexes.size(); ++i) {
            if (((TQuad)workspace.get(newIndexes.getInt(i))).extentsEqual(oldExtents[i])) continue;
            return null;
        }
        IndexRemapper remapper = new IndexRemapper(reuseData.maxIndex + 1, newIndexes);
        BSPSortState.decompressOrRead(reuseData.indexes, remapper);
        if (remapper.hasFixedOffset()) {
            oldNode.fixedIndexOffset = remapper.firstOffset;
        } else {
            oldNode.indexMap = remapper.indexMap;
        }
        oldNode.addPartitionPlanes(workspace);
        return oldNode;
    }

    private static long encodeIntervalPoint(float distance, int quadIndex, int type) {
        return (long)MathUtil.floatToComparableInt(distance) << 32 | (long)type << 30 | (long)quadIndex;
    }

    private static float decodeDistance(long encoded) {
        return MathUtil.comparableIntToFloat((int)(encoded >>> 32));
    }

    private static int decodeQuadIndex(long encoded) {
        return (int)(encoded & 0x3FFFFFFFL);
    }

    private static int decodeType(long encoded) {
        return (int)(encoded >>> 30) & 3;
    }

    public static void validateQuadCount(int quadCount) {
        if (quadCount * 2 > 0x3FFFFFFF) {
            throw new IllegalArgumentException("Too many quads: " + quadCount);
        }
    }

    static BSPNode build(BSPWorkspace workspace, IntArrayList indexes, int depth, BSPNode oldNode) {
        InnerPartitionBSPNode oldInnerNode;
        InnerPartitionBSPNode reusedNode;
        if (oldNode instanceof InnerPartitionBSPNode && (reusedNode = InnerPartitionBSPNode.attemptNodeReuse(workspace, indexes, oldInnerNode = (InnerPartitionBSPNode)oldNode)) != null) {
            return reusedNode;
        }
        ReferenceArrayList partitions = new ReferenceArrayList();
        LongArrayList points = new LongArrayList((int)((double)indexes.size() * 1.5));
        IntArrayList bestSplittingGroup = null;
        IntArrayList splittingGroup = null;
        boolean canSplitQuads = workspace.canSplitQuads();
        if (canSplitQuads) {
            bestSplittingGroup = new IntArrayList(5);
            splittingGroup = new IntArrayList(5);
        }
        for (int axisCount = 0; axisCount < 3; ++axisCount) {
            boolean endsWithPlane;
            int alignedNormalCount;
            int axis = (axisCount + depth + 1) % 3;
            int oppositeDirection = axis + 3;
            int alignedFacingBitmap = 0;
            boolean onlyIntervalSide = true;
            int positiveSignCount = 0;
            points.clear();
            int size = indexes.size();
            for (int i = 0; i < size; ++i) {
                float negExtent;
                int quadIndex = indexes.getInt(i);
                TQuad quad = (TQuad)workspace.get(quadIndex);
                float[] extents = quad.getExtents();
                float posExtent = extents[axis];
                if (posExtent == (negExtent = extents[oppositeDirection])) {
                    points.add(InnerPartitionBSPNode.encodeIntervalPoint(posExtent, quadIndex, 1));
                } else {
                    points.add(InnerPartitionBSPNode.encodeIntervalPoint(posExtent, quadIndex, 0));
                    points.add(InnerPartitionBSPNode.encodeIntervalPoint(negExtent, quadIndex, 2));
                    onlyIntervalSide = false;
                }
                ModelQuadFacing facing = quad.getFacing();
                if (facing.getSign() > 0) {
                    ++positiveSignCount;
                }
                alignedFacingBitmap |= 1 << facing.ordinal();
            }
            if (!ModelQuadFacing.bitmapHasUnassigned(alignedFacingBitmap) && ((alignedNormalCount = Integer.bitCount(alignedFacingBitmap)) == 1 || alignedNormalCount == 2 && ModelQuadFacing.bitmapIsOpposingAligned(alignedFacingBitmap))) {
                if (onlyIntervalSide) {
                    return InnerPartitionBSPNode.buildSNRLeafNodeFromPoints(workspace, points, positiveSignCount);
                }
                return InnerPartitionBSPNode.buildSNRLeafNodeFromQuads(workspace, indexes);
            }
            Arrays.sort(points.elements(), 0, points.size());
            float distance = Float.NaN;
            IntArrayList quadsBefore = null;
            IntArrayList quadsOn = null;
            int thickness = 0;
            partitions.clear();
            if (canSplitQuads) {
                splittingGroup.clear();
            }
            float splitDistance = Float.NaN;
            int size2 = points.size();
            block7: for (int i = 0; i < size2; ++i) {
                long point = points.getLong(i);
                switch (InnerPartitionBSPNode.decodeType(point)) {
                    case 2: {
                        if (thickness == 0 && (quadsBefore != null || quadsOn != null)) {
                            partitions.add((Object)new Partition(distance, quadsBefore, quadsOn));
                            distance = Float.NaN;
                            quadsBefore = null;
                            quadsOn = null;
                        }
                        ++thickness;
                        if (quadsOn != null) {
                            if (Float.isNaN(distance)) {
                                throw new IllegalStateException("distance not set");
                            }
                            partitions.add((Object)new Partition(distance, quadsBefore, quadsOn));
                            distance = Float.NaN;
                            quadsOn = null;
                        }
                        if (quadsBefore == null) {
                            quadsBefore = new IntArrayList();
                        }
                        quadsBefore.add(InnerPartitionBSPNode.decodeQuadIndex(point));
                        continue block7;
                    }
                    case 0: {
                        --thickness;
                        if (quadsOn != null) continue block7;
                        distance = InnerPartitionBSPNode.decodeDistance(point);
                        continue block7;
                    }
                    case 1: {
                        int pointQuadIndex = InnerPartitionBSPNode.decodeQuadIndex(point);
                        if (thickness == 0) {
                            float pointDistance = InnerPartitionBSPNode.decodeDistance(point);
                            if (quadsOn == null) {
                                quadsOn = new IntArrayList();
                                distance = pointDistance;
                            } else if (distance != pointDistance) {
                                partitions.add((Object)new Partition(distance, quadsBefore, quadsOn));
                                distance = pointDistance;
                                quadsBefore = null;
                                quadsOn = new IntArrayList();
                            }
                            quadsOn.add(pointQuadIndex);
                            continue block7;
                        }
                        if (quadsBefore == null) {
                            throw new IllegalStateException("there must be started intervals here");
                        }
                        quadsBefore.add(pointQuadIndex);
                        if (!canSplitQuads) continue block7;
                        float ownDistance = InnerPartitionBSPNode.decodeDistance(point);
                        if (ownDistance == splitDistance || Float.isNaN(splitDistance)) {
                            splittingGroup.add(pointQuadIndex);
                        } else {
                            InnerPartitionBSPNode.flushBestSplittingGroup(splittingGroup, bestSplittingGroup, axis);
                        }
                        splitDistance = ownDistance;
                    }
                }
            }
            if (canSplitQuads) {
                InnerPartitionBSPNode.flushBestSplittingGroup(splittingGroup, bestSplittingGroup, axis);
            }
            if (quadsBefore != null && quadsBefore.size() == indexes.size()) continue;
            boolean bl = endsWithPlane = quadsOn != null;
            if (quadsBefore != null || quadsOn != null) {
                partitions.add((Object)new Partition(endsWithPlane ? distance : Float.NaN, quadsBefore, quadsOn));
            }
            if (partitions.size() <= 2) {
                Partition outside;
                Partition inside = (Partition)partitions.get(0);
                Partition partition = outside = partitions.size() == 2 ? (Partition)partitions.get(1) : null;
                if (outside == null || !endsWithPlane) {
                    return InnerBinaryPartitionBSPNode.buildFromPartitions(workspace, indexes, depth, oldNode, inside, outside, axis);
                }
            }
            return InnerMultiPartitionBSPNode.buildFromPartitions(workspace, indexes, depth, oldNode, (ReferenceArrayList<Partition>)partitions, axis, endsWithPlane);
        }
        if (canSplitQuads) {
            BSPNode multiLeafNode = InnerPartitionBSPNode.buildTopoMultiLeafNode(workspace, indexes, true);
            if (multiLeafNode != null) {
                return multiLeafNode;
            }
            return InnerPartitionBSPNode.handleUnsortableBySplitting(workspace, indexes, depth, oldNode, bestSplittingGroup);
        }
        BSPNode intersectingHandling = InnerPartitionBSPNode.handleIntersecting(workspace, indexes, depth, oldNode);
        if (intersectingHandling != null) {
            return intersectingHandling;
        }
        BSPNode multiLeafNode = InnerPartitionBSPNode.buildTopoMultiLeafNode(workspace, indexes, false);
        if (multiLeafNode == null) {
            throw new BSPBuildFailureException("No partition found but not intersecting and can't be statically topo sorted");
        }
        return multiLeafNode;
    }

    static void flushBestSplittingGroup(IntArrayList splittingGroup, IntArrayList bestSplittingGroup, int axis) {
        int newSize;
        int currentSize = splittingGroup.size();
        if (currentSize > (newSize = bestSplittingGroup.size()) || currentSize == newSize && axis == 1) {
            bestSplittingGroup.clear();
            bestSplittingGroup.addAll((IntList)splittingGroup);
        }
        splittingGroup.clear();
    }

    private static boolean floatEquals(float a, float b) {
        return Float.floatToIntBits(a) == Float.floatToIntBits(b) || Math.abs(a - b) <= 1.0E-5f;
    }

    private static BSPNode handleUnsortableBySplitting(BSPWorkspace workspace, IntArrayList indexes, int depth, BSPNode oldNode, IntArrayList splittingGroup) {
        float dotProduct;
        Vector3fc normal;
        ModelQuadFacing facing;
        int representativeIndex;
        if (splittingGroup.isEmpty()) {
            representativeIndex = indexes.getInt(0);
            splittingGroup.add(representativeIndex);
        } else {
            representativeIndex = splittingGroup.getInt(0);
        }
        FullTQuad representative = (FullTQuad)workspace.get(representativeIndex);
        ModelQuadFacing representativeFacing = representative.getFacing();
        int initialSplittingGroupSize = splittingGroup.size();
        Vector3fc splitPlane = representative.getVeryAccurateNormal();
        float splitDistance = representative.getAccurateDotProduct();
        Vector3f splitPlaneNeg = splitPlane.negate(new Vector3f());
        float splitDistanceNeg = -splitDistance;
        boolean splitPlaneIsAligned = representativeFacing.isAligned();
        IntArrayList inside = new IntArrayList();
        IntArrayList outside = new IntArrayList();
        IntListIterator intListIterator = indexes.iterator();
        while (intListIterator.hasNext()) {
            int candidateIndex = (Integer)intListIterator.next();
            boolean isInSplittingGroup = false;
            for (int i = 0; i < initialSplittingGroupSize; ++i) {
                if (candidateIndex != splittingGroup.getInt(i)) continue;
                isInSplittingGroup = true;
            }
            if (isInSplittingGroup) continue;
            FullTQuad insideQuad = (FullTQuad)workspace.get(candidateIndex);
            ModelQuadFacing quadFacing = insideQuad.getFacing();
            if (quadFacing == representativeFacing) {
                boolean antiCoplanar;
                Vector3fc accurateNormal = insideQuad.getVeryAccurateNormal();
                float accurateDotProduct = insideQuad.getAccurateDotProduct();
                boolean coplanar = InnerPartitionBSPNode.floatEquals(accurateDotProduct, splitDistance) && (splitPlaneIsAligned || accurateNormal.equals(splitPlane, 1.0E-5f));
                boolean bl = antiCoplanar = coplanar || InnerPartitionBSPNode.floatEquals(accurateDotProduct, splitDistanceNeg) && (splitPlaneIsAligned || accurateNormal.equals((Vector3fc)splitPlaneNeg, 1.0E-5f));
                if (coplanar || antiCoplanar) {
                    splittingGroup.add(candidateIndex);
                    continue;
                }
            }
            InnerPartitionBSPNode.splitCandidate(workspace, splittingGroup, candidateIndex, insideQuad, splitPlane, splitDistance, outside, inside);
        }
        if (workspace.quantizeTriggerNormals) {
            facing = representative.useQuantizedFacing();
            normal = representative.getQuantizedNormal();
            dotProduct = representative.getQuantizedDotProduct();
        } else {
            facing = representativeFacing;
            normal = splitPlane;
            dotProduct = splitDistance;
        }
        int axis = -1;
        if (facing.isAligned()) {
            axis = facing.getAxis();
        }
        return InnerBinaryPartitionBSPNode.buildFromParts(workspace, indexes, depth, oldNode, inside, outside, splittingGroup, axis, normal, dotProduct);
    }

    private static void splitCandidate(BSPWorkspace workspace, IntArrayList splittingGroup, int candidateIndex, FullTQuad insideQuad, Vector3fc splitPlane, float splitDistance, IntArrayList outside, IntArrayList inside) {
        int uniqueVertexMap = insideQuad.getUniqueVertexMap();
        int uniqueVertices = Integer.bitCount(uniqueVertexMap);
        if (uniqueVertices < 3) {
            throw new IllegalStateException("Unexpected quad with less than 3 unique vertices");
        }
        ChunkVertexEncoder.Vertex[] vertices = insideQuad.getVertices();
        int insideMapUnmasked = 0;
        int onPlaneMapUnmasked = 0;
        for (int i = 0; i < 4; ++i) {
            ChunkVertexEncoder.Vertex vertex = vertices[i];
            float dot = splitPlane.dot(vertex.x, vertex.y, vertex.z);
            float delta = dot - splitDistance;
            if (Math.abs(delta) < 1.0E-5f) {
                onPlaneMapUnmasked |= 1 << i;
                continue;
            }
            if (!(delta < 0.0f)) continue;
            insideMapUnmasked |= 1 << i;
        }
        int insideMap = insideMapUnmasked & uniqueVertexMap;
        int onPlaneMap = onPlaneMapUnmasked & uniqueVertexMap;
        if (onPlaneMap == uniqueVertexMap) {
            splittingGroup.add(candidateIndex);
            return;
        }
        if (insideMap == 0) {
            outside.add(candidateIndex);
            return;
        }
        if ((insideMap | onPlaneMap) == uniqueVertexMap) {
            inside.add(candidateIndex);
            return;
        }
        int onPlaneCount = Integer.bitCount(onPlaneMap);
        int insideCount = Integer.bitCount(insideMap);
        if (!workspace.canSplitQuads()) {
            int outsideCount = 4 - insideCount - onPlaneCount;
            if (onPlaneCount >= insideCount && onPlaneCount >= outsideCount) {
                splittingGroup.add(candidateIndex);
            } else if (insideCount >= outsideCount) {
                inside.add(candidateIndex);
            } else {
                outside.add(candidateIndex);
            }
            return;
        }
        FullTQuad outsideQuad = FullTQuad.splittingCopy(insideQuad);
        FullTQuad secondOutsideQuad = null;
        FullTQuad secondInsideQuad = null;
        if (uniqueVertices == 3) {
            int sameVertexMap = insideQuad.getSameVertexMap();
            if (onPlaneCount == 1) {
                int duplicateIndex = -1;
                boolean duplicateIsInside = false;
                if ((onPlaneMapUnmasked & sameVertexMap) == 0) {
                    duplicateIsInside = (sameVertexMap & insideMapUnmasked) != 0;
                    duplicateIndex = Integer.numberOfTrailingZeros(sameVertexMap);
                }
                int insideIndex = Integer.numberOfTrailingZeros(insideMap);
                int outsideIndex = Integer.numberOfTrailingZeros(~(insideMap | onPlaneMap) & uniqueVertexMap);
                InnerPartitionBSPNode.splitTriangleVertex(insideIndex, outsideIndex, duplicateIndex, duplicateIsInside, insideQuad, outsideQuad, splitPlane, splitDistance);
            } else if (Integer.bitCount(insideMapUnmasked) == 2) {
                InnerPartitionBSPNode.splitQuadEven(insideMapUnmasked, insideQuad, outsideQuad, splitPlane, splitDistance);
            } else if (insideCount == 1) {
                int cornerIndex = Integer.numberOfTrailingZeros(insideMap);
                InnerPartitionBSPNode.splitTriangleCorner(cornerIndex, insideQuad, outsideQuad, splitPlane, splitDistance);
            } else {
                int cornerIndex = Integer.numberOfTrailingZeros(~insideMapUnmasked);
                InnerPartitionBSPNode.splitTriangleCorner(cornerIndex, outsideQuad, insideQuad, splitPlane, splitDistance);
            }
        } else {
            if (onPlaneCount == 2 && onPlaneMap == 5) {
                insideMap |= 1;
                insideCount = 2;
            } else if (onPlaneCount == 2 && onPlaneMap == 10) {
                insideMap |= 2;
                insideCount = 2;
            } else if (onPlaneCount == 1 && insideCount == 1) {
                insideMap |= onPlaneMap;
                insideCount = 2;
            }
            if (insideCount == 2) {
                InnerPartitionBSPNode.splitQuadEven(insideMap, insideQuad, outsideQuad, splitPlane, splitDistance);
            } else if (insideCount == 3) {
                int cornerIndex = Integer.numberOfTrailingZeros(~insideMap);
                secondInsideQuad = FullTQuad.splittingCopy(insideQuad);
                InnerPartitionBSPNode.splitQuadOdd(cornerIndex, outsideQuad, secondInsideQuad, insideQuad, splitPlane, splitDistance);
            } else {
                int cornerIndex = Integer.numberOfTrailingZeros(insideMap);
                secondOutsideQuad = FullTQuad.splittingCopy(insideQuad);
                InnerPartitionBSPNode.splitQuadOdd(cornerIndex, insideQuad, secondOutsideQuad, outsideQuad, splitPlane, splitDistance);
            }
        }
        InnerPartitionBSPNode.addQuadIndex(inside, workspace.updateQuad(insideQuad, candidateIndex));
        InnerPartitionBSPNode.addQuadIndex(outside, workspace.pushQuad(outsideQuad));
        InnerPartitionBSPNode.addQuadIndex(inside, workspace.pushQuad(secondInsideQuad));
        InnerPartitionBSPNode.addQuadIndex(outside, workspace.pushQuad(secondOutsideQuad));
    }

    private static void addQuadIndex(IntArrayList list, int index) {
        if (index >= 0) {
            list.add(index);
        }
    }

    private static void splitQuadEven(int vertexInsideMap, FullTQuad insideQuad, FullTQuad outsideQuad, Vector3fc splitPlane, float splitDistance) {
        ChunkVertexEncoder.Vertex[] insideVertices = insideQuad.getVertices();
        ChunkVertexEncoder.Vertex[] outsideVertices = outsideQuad.getVertices();
        for (int indexA = 0; indexA < 4; ++indexA) {
            int outsideIndex;
            int insideIndex;
            boolean insideB;
            int indexB = indexA + 1 & 3;
            boolean insideA = (vertexInsideMap & 1 << indexA) != 0;
            boolean bl = insideB = (vertexInsideMap & 1 << indexB) != 0;
            if (insideA == insideB) continue;
            if (insideA) {
                insideIndex = indexA;
                outsideIndex = indexB;
            } else {
                insideIndex = indexB;
                outsideIndex = indexA;
            }
            InnerPartitionBSPNode.interpolateAttributes(splitDistance, splitPlane, insideVertices[insideIndex], outsideVertices[outsideIndex], insideVertices[outsideIndex], outsideVertices[insideIndex]);
        }
        insideQuad.updateSplitQuadAfterVertexModification();
        outsideQuad.updateSplitQuadAfterVertexModification();
    }

    private static void splitQuadOdd(int cornerIndex, FullTQuad cornerQuad, FullTQuad cutQuad, FullTQuad bulkQuad, Vector3fc splitPlane, float splitDistance) {
        ChunkVertexEncoder.Vertex[] cornerVertices = cornerQuad.getVertices();
        ChunkVertexEncoder.Vertex[] cutVertices = cutQuad.getVertices();
        ChunkVertexEncoder.Vertex[] bulkVertices = bulkQuad.getVertices();
        int prevIndex = cornerIndex - 1 & 3;
        int nextIndex = cornerIndex + 1 & 3;
        int oppositeIndex = cornerIndex + 2 & 3;
        ChunkVertexEncoder.Vertex cornerVertex = cornerVertices[cornerIndex];
        InnerPartitionBSPNode.interpolateAttributes(splitDistance, splitPlane, cornerVertex, bulkVertices[nextIndex], cornerVertices[nextIndex], cutVertices[nextIndex], bulkVertices[cornerIndex]);
        InnerPartitionBSPNode.interpolateAttributes(splitDistance, splitPlane, cornerVertex, bulkVertices[prevIndex], cornerVertices[prevIndex], cornerVertices[oppositeIndex], cutVertices[cornerIndex]);
        ChunkVertexEncoder.Vertex.copyVertexTo(cutVertices[prevIndex], cutVertices[oppositeIndex]);
        cornerQuad.updateSplitQuadAfterVertexModification();
        cutQuad.updateSplitQuadAfterVertexModification();
        bulkQuad.updateSplitQuadAfterVertexModification();
    }

    private static void splitTriangleCorner(int cornerIndex, FullTQuad cornerQuad, FullTQuad bulkQuad, Vector3fc splitPlane, float splitDistance) {
        ChunkVertexEncoder.Vertex[] cornerVertices = cornerQuad.getVertices();
        ChunkVertexEncoder.Vertex[] bulkVertices = bulkQuad.getVertices();
        int prevIndex = cornerIndex - 1 & 3;
        int nextIndex = cornerIndex + 1 & 3;
        int oppositeIndex = cornerIndex + 2 & 3;
        ChunkVertexEncoder.Vertex cornerVertex = cornerVertices[cornerIndex];
        InnerPartitionBSPNode.interpolateAttributes(splitDistance, splitPlane, cornerVertex, bulkVertices[nextIndex], cornerVertices[nextIndex], cornerVertices[oppositeIndex], bulkVertices[cornerIndex]);
        ChunkVertexEncoder.Vertex.copyVertexTo(bulkVertices[prevIndex], bulkVertices[oppositeIndex]);
        InnerPartitionBSPNode.interpolateAttributes(splitDistance, splitPlane, cornerVertex, bulkVertices[prevIndex], cornerVertices[prevIndex], bulkVertices[prevIndex]);
        cornerQuad.updateSplitQuadAfterVertexModification();
        bulkQuad.updateSplitQuadAfterVertexModification();
    }

    private static void splitTriangleVertex(int insideIndex, int outsideIndex, int duplicateIndex, boolean duplicateIsInside, FullTQuad insideQuad, FullTQuad outsideQuad, Vector3fc splitPlane, float splitDistance) {
        ChunkVertexEncoder.Vertex[] insideVertices = insideQuad.getVertices();
        ChunkVertexEncoder.Vertex[] outsideVertices = outsideQuad.getVertices();
        ChunkVertexEncoder.Vertex duplicateTarget = null;
        if (duplicateIndex != -1) {
            duplicateTarget = duplicateIsInside ? outsideVertices[duplicateIndex] : insideVertices[duplicateIndex];
        }
        InnerPartitionBSPNode.interpolateAttributes(splitDistance, splitPlane, insideVertices[insideIndex], outsideVertices[outsideIndex], insideVertices[outsideIndex], outsideVertices[insideIndex], duplicateTarget);
        insideQuad.updateSplitQuadAfterVertexModification();
        outsideQuad.updateSplitQuadAfterVertexModification();
    }

    private static void interpolateAttributes(float splitDistance, Vector3fc splitPlane, ChunkVertexEncoder.Vertex inside, ChunkVertexEncoder.Vertex outside, ChunkVertexEncoder.Vertex targetA, ChunkVertexEncoder.Vertex targetB) {
        InnerPartitionBSPNode.interpolateAttributes(splitDistance, splitPlane, inside, outside, targetA, targetB, null);
    }

    private static void interpolateAttributes(float splitDistance, Vector3fc splitPlane, ChunkVertexEncoder.Vertex inside, ChunkVertexEncoder.Vertex outside, ChunkVertexEncoder.Vertex targetA, ChunkVertexEncoder.Vertex targetB, ChunkVertexEncoder.Vertex targetC) {
        float insideToOutsideX = outside.x - inside.x;
        float insideToOutsideY = outside.y - inside.y;
        float insideToOutsideZ = outside.z - inside.z;
        if (Math.abs(insideToOutsideX) < 1.0E-5f && Math.abs(insideToOutsideY) < 1.0E-5f && Math.abs(insideToOutsideZ) < 1.0E-5f) {
            InnerPartitionBSPNode.copyVertexToMultiple(inside, targetA, targetB, targetC);
            return;
        }
        float splitPlaneEdgeDot = splitPlane.dot(insideToOutsideX, insideToOutsideY, insideToOutsideZ);
        if (splitPlaneEdgeDot == 0.0f) {
            throw new IllegalStateException("Quad with an edge in the split plane should have been handled earlier");
        }
        float outsideAmount = (splitDistance - splitPlane.dot(inside.x, inside.y, inside.z)) / splitPlaneEdgeDot;
        if (outsideAmount >= 1.0f) {
            InnerPartitionBSPNode.copyVertexToMultiple(outside, targetA, targetB, targetC);
            return;
        }
        if (outsideAmount <= 0.0f) {
            InnerPartitionBSPNode.copyVertexToMultiple(inside, targetA, targetB, targetC);
            return;
        }
        float newX = inside.x + insideToOutsideX * outsideAmount;
        float newY = inside.y + insideToOutsideY * outsideAmount;
        float newZ = inside.z + insideToOutsideZ * outsideAmount;
        int newColor = ColorMixer.mix(inside.color, outside.color, outsideAmount);
        float newAo = class_3532.method_16439((float)outsideAmount, (float)inside.ao, (float)outside.ao);
        float newU = class_3532.method_16439((float)outsideAmount, (float)inside.u, (float)outside.u);
        float newV = class_3532.method_16439((float)outsideAmount, (float)inside.v, (float)outside.v);
        float newLightBl = class_3532.method_16439((float)outsideAmount, (float)(inside.light & 0xFF), (float)(outside.light & 0xFF));
        float newLightSl = class_3532.method_16439((float)outsideAmount, (float)(inside.light >> 16), (float)(outside.light >> 16));
        int newLight = ((int)newLightSl & 0xFF) << 16 | (int)newLightBl & 0xFF;
        ChunkVertexEncoder.Vertex.writeVertex(targetA, newX, newY, newZ, newColor, newAo, newU, newV, newLight);
        ChunkVertexEncoder.Vertex.writeVertex(targetB, newX, newY, newZ, newColor, newAo, newU, newV, newLight);
        if (targetC != null) {
            ChunkVertexEncoder.Vertex.writeVertex(targetC, newX, newY, newZ, newColor, newAo, newU, newV, newLight);
        }
    }

    private static void copyVertexToMultiple(ChunkVertexEncoder.Vertex from, ChunkVertexEncoder.Vertex targetA, ChunkVertexEncoder.Vertex targetB, ChunkVertexEncoder.Vertex targetC) {
        ChunkVertexEncoder.Vertex.copyVertexTo(from, targetA);
        ChunkVertexEncoder.Vertex.copyVertexTo(from, targetB);
        if (targetC != null) {
            ChunkVertexEncoder.Vertex.copyVertexTo(from, targetC);
        }
    }

    private static BSPNode handleIntersecting(BSPWorkspace workspace, IntArrayList indexes, int depth, BSPNode oldNode) {
        IntOpenHashSet primaryIntersectorIndexes;
        block12: {
            Int2IntOpenHashMap intersectionCounts = null;
            primaryIntersectorIndexes = null;
            int primaryIntersectorThreshold = class_3532.method_15340((int)(indexes.size() / 2), (int)2, (int)4);
            int i = -1;
            int j = 0;
            int quadCount = indexes.size();
            int stepSize = Math.max(1, quadCount * (quadCount - 1) / 2 / 500);
            int variance = 0;
            Random random = null;
            if (stepSize > 1) {
                int half = stepSize / 2;
                variance = stepSize = Math.max(1, stepSize - half);
                random = new Random();
            }
            while (true) {
                TQuad quadB;
                i += stepSize;
                if (variance > 0) {
                    i += random.nextInt(variance);
                }
                while (i >= j) {
                    i -= j;
                    ++j;
                }
                if (j >= indexes.size()) break block12;
                TQuad quadA = (TQuad)workspace.get(indexes.getInt(i));
                if (!TQuad.extentsIntersect(quadA, quadB = (TQuad)workspace.get(indexes.getInt(j)))) continue;
                if (intersectionCounts == null) {
                    intersectionCounts = new Int2IntOpenHashMap();
                }
                int aCount = intersectionCounts.get(i) + 1;
                intersectionCounts.put(i, aCount);
                int bCount = intersectionCounts.get(j) + 1;
                intersectionCounts.put(j, bCount);
                if (aCount >= primaryIntersectorThreshold) {
                    if (primaryIntersectorIndexes == null) {
                        primaryIntersectorIndexes = new IntOpenHashSet(2);
                    }
                    primaryIntersectorIndexes.add(i);
                }
                if (bCount >= primaryIntersectorThreshold) {
                    if (primaryIntersectorIndexes == null) {
                        primaryIntersectorIndexes = new IntOpenHashSet(2);
                    }
                    primaryIntersectorIndexes.add(j);
                }
                if (primaryIntersectorIndexes != null && primaryIntersectorIndexes.size() == indexes.size()) break;
            }
            return new LeafMultiBSPNode(BSPSortState.compressIndexes(indexes));
        }
        if (primaryIntersectorIndexes != null) {
            IntArrayList nonPrimaryIntersectors = new IntArrayList(indexes.size() - primaryIntersectorIndexes.size());
            IntArrayList primaryIntersectorQuadIndexes = new IntArrayList(primaryIntersectorIndexes.size());
            for (int k = 0; k < indexes.size(); ++k) {
                if (primaryIntersectorIndexes.contains(k)) {
                    primaryIntersectorQuadIndexes.add(indexes.getInt(k));
                    continue;
                }
                nonPrimaryIntersectors.add(indexes.getInt(k));
            }
            return InnerFixedDoubleBSPNode.buildFromParts(workspace, indexes, depth, oldNode, nonPrimaryIntersectors, primaryIntersectorQuadIndexes);
        }
        return null;
    }

    private static BSPNode buildTopoMultiLeafNode(BSPWorkspace workspace, IntArrayList indexes, boolean failOnIntersection) {
        int quadCount = indexes.size();
        if (quadCount > TranslucentGeometryCollector.STATIC_TOPO_UNKNOWN_FALLBACK_LIMIT) {
            return null;
        }
        TQuad[] quads = new TQuad[quadCount];
        int[] activeToRealIndex = new int[quadCount];
        for (int i = 0; i < indexes.size(); ++i) {
            int quadIndex = indexes.getInt(i);
            quads[i] = (TQuad)workspace.get(quadIndex);
            activeToRealIndex[i] = quadIndex;
        }
        QuadIndexConsumerIntoArray indexWriter = new QuadIndexConsumerIntoArray(quadCount);
        if (!TopoGraphSorting.topoGraphSort((IntConsumer)((Object)indexWriter), quads, quads.length, activeToRealIndex, null, null, failOnIntersection)) {
            return null;
        }
        return new LeafMultiBSPNode(BSPSortState.compressIndexesInPlace(indexWriter.indexes, false));
    }

    private static BSPNode buildSNRLeafNodeFromQuads(BSPWorkspace workspace, IntArrayList indexes) {
        int i;
        int[] indexBuffer = indexes.elements();
        int indexCount = indexes.size();
        int[] keys = new int[indexCount];
        int[] perm = new int[indexCount];
        for (i = 0; i < indexCount; ++i) {
            TQuad quad = (TQuad)workspace.get(indexBuffer[i]);
            keys[i] = MathUtil.floatToComparableInt(quad.getAccurateDotProduct());
            perm[i] = i;
        }
        RadixSort.sortIndirect(perm, keys, true);
        for (i = 0; i < indexCount; ++i) {
            perm[i] = indexBuffer[perm[i]];
        }
        return new LeafMultiBSPNode(BSPSortState.compressIndexes(IntArrayList.wrap((int[])perm), false));
    }

    private static BSPNode buildSNRLeafNodeFromPoints(BSPWorkspace workspace, LongArrayList points, int positiveSignCount) {
        int pointCount = points.size();
        if (positiveSignCount < pointCount) {
            for (int i = 0; i < pointCount; ++i) {
                long point = points.getLong(i);
                int quadIndex = InnerPartitionBSPNode.decodeQuadIndex(point);
                if (((TQuad)workspace.get(quadIndex)).getFacing().getSign() != -1) continue;
                points.set(i, point ^ 0xFFFFFFFF00000000L);
            }
        }
        Arrays.sort(points.elements(), 0, pointCount);
        int[] quadIndexes = new int[pointCount];
        int positive = 0;
        int negative = positiveSignCount;
        for (int i = 0; i < pointCount; ++i) {
            int quadIndex = InnerPartitionBSPNode.decodeQuadIndex(points.getLong(i));
            if (((TQuad)workspace.get(quadIndex)).getFacing().getSign() == 1) {
                quadIndexes[positive++] = quadIndex;
                continue;
            }
            quadIndexes[negative++] = quadIndex;
        }
        return new LeafMultiBSPNode(BSPSortState.compressIndexes(IntArrayList.wrap((int[])quadIndexes), false));
    }

    record NodeReuseData(float[][] quadExtents, int[] indexes, int indexCount, int maxIndex) {
    }

    private static class IndexRemapper
    implements it.unimi.dsi.fastutil.ints.IntConsumer {
        private final int[] indexMap;
        private final IntArrayList newIndexes;
        private int index = 0;
        private int firstOffset = 0;
        private static final int OFFSET_CHANGED = Integer.MIN_VALUE;

        IndexRemapper(int length, IntArrayList newIndexes) {
            this.indexMap = new int[length];
            this.newIndexes = newIndexes;
        }

        public void accept(int oldIndex) {
            int newIndex;
            this.indexMap[oldIndex] = newIndex = this.newIndexes.getInt(this.index);
            int newOffset = newIndex - oldIndex;
            if (this.index == 0) {
                this.firstOffset = newOffset;
            } else if (this.firstOffset != newOffset) {
                this.firstOffset = Integer.MIN_VALUE;
            }
            ++this.index;
        }

        boolean hasFixedOffset() {
            return this.firstOffset != Integer.MIN_VALUE;
        }
    }

    private static class QuadIndexConsumerIntoArray
    implements it.unimi.dsi.fastutil.ints.IntConsumer {
        final int[] indexes;
        private int index = 0;

        QuadIndexConsumerIntoArray(int size) {
            this.indexes = new int[size];
        }

        public void accept(int value) {
            this.indexes[this.index++] = value;
        }
    }
}

