/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.mesh;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.render.frapi.wrapper.ExtendedQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.wrapper.MutableQuadViewWrapper;
import net.caffeinemc.mods.sodium.client.render.frapi.wrapper.QuadViewWrapper;
import net.caffeinemc.mods.sodium.client.render.model.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.model.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.model.QuadViewImpl;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import org.jetbrains.annotations.Range;

public class MeshViewImpl
implements MeshView {
    private static final ThreadLocal<ObjectArrayList<QuadViewWrapper>> CURSOR_POOLS = ThreadLocal.withInitial(ObjectArrayList::new);
    int[] data;
    int limit;

    MeshViewImpl() {
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int size() {
        return this.limit / EncodingFormat.TOTAL_STRIDE;
    }

    public void forEach(Consumer<? super QuadView> action) {
        ObjectArrayList<QuadViewWrapper> pool = CURSOR_POOLS.get();
        QuadViewWrapper cursor = pool.isEmpty() ? ((ExtendedQuadViewImpl)((Object)new QuadViewImpl())).getWrapper() : (QuadViewWrapper)pool.pop();
        this.forEach(action, cursor);
        pool.push((Object)cursor);
    }

    void forEach(Consumer<? super QuadView> action, QuadView c) {
        QuadViewImpl cursor = ((QuadViewWrapper)c).getOriginal();
        int limit = this.limit;
        cursor.data = this.data;
        for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
            cursor.baseIndex = index;
            cursor.load();
            action.accept((QuadView)c);
        }
        cursor.data = null;
    }

    public void outputTo(QuadEmitter emitter) {
        MutableQuadViewWrapper emitters = (MutableQuadViewWrapper)emitter;
        MutableQuadViewImpl e = emitters.getOriginal();
        int[] data = this.data;
        int limit = this.limit;
        for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
            System.arraycopy(data, index, e.data, e.baseIndex, EncodingFormat.TOTAL_STRIDE);
            e.load();
            emitters.transformAndEmit();
        }
        e.clear();
    }
}

