/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.util.minecraft;

import com.hyfata.najoan.koreanpatch.mixin.accessor.GuiGraphicsAccessor;
import com.hyfata.najoan.koreanpatch.util.minecraft.gui.FloatRenderState;
import com.hyfata.najoan.koreanpatch.util.minecraft.gui.FloatTextRenderState;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11247;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5481;
import net.minecraft.class_9848;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class RenderUtil {
    private static final class_310 client = class_310.method_1551();

    public static void drawCenteredText(class_332 guiGraphics, class_5481 text, float x, float y) {
        RenderUtil.drawCenteredText(guiGraphics, text, x, y, -1);
    }

    public static void drawCenteredText(class_332 guiGraphics, class_5481 text, float x, float y, int color) {
        class_327 textRenderer = RenderUtil.client.field_1772;
        float textWidth = textRenderer.method_30880(text);
        float xPosition = x - textWidth / 2.0f;
        Objects.requireNonNull(RenderUtil.client.field_1772);
        float yPosition = y - 9.0f / 2.0f;
        RenderUtil.drawText(guiGraphics, text, xPosition, yPosition, color);
    }

    public static void drawText(class_332 guiGraphics, class_5481 text, float x, float y) {
        RenderUtil.drawText(guiGraphics, text, x, y, -1);
    }

    public static void drawText(class_332 guiGraphics, class_5481 text, float x, float y, int color) {
        if (class_9848.method_61320((int)color) != 0) {
            GuiGraphicsAccessor accessor = (GuiGraphicsAccessor)guiGraphics;
            accessor.getGuiRenderState().method_70921((class_11247)new FloatTextRenderState(RenderUtil.client.field_1772, text, new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()), x, y, color, 0, true, false, accessor.getScissorStack().method_70863()));
        }
    }

    public static void fill(class_332 guiGraphics, float x1, float y1, float x2, float y2, int color) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        RenderUtil.submitColoredRectangle(guiGraphics, class_11231.method_70899(), x1, y1, x2, y2, color);
    }

    private static void submitColoredRectangle(class_332 guiGraphics, class_11231 textureSetup, float x0, float y0, float x1, float y1, int col1) {
        GuiGraphicsAccessor accessor = (GuiGraphicsAccessor)guiGraphics;
        accessor.getGuiRenderState().method_70919((class_11244)new FloatRenderState(class_10799.field_56879, textureSetup, new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()), x0, y0, x1, y1, col1, col1, accessor.getScissorStack().method_70863()));
    }

    public static void drawVertexCircleFrame(class_332 guiGraphics, float centerX, float centerY, float radius, int frameColor, float frameThickness, VertexDirection direction) {
        float innerRadius = radius - frameThickness;
        if (innerRadius < 0.0f) {
            throw new IllegalArgumentException("Frame thickness cannot be greater than the outer radius.");
        }
        int steps = 18;
        float angleStep = 1.5707964f / (float)steps;
        float cos = 1.0f;
        float sin = 0.0f;
        float cosDelta = class_3532.method_15362((double)angleStep);
        float sinDelta = class_3532.method_15374((double)angleStep);
        for (int i = 0; i < steps; ++i) {
            float tempCos = cos;
            cos = cos * cosDelta - sin * sinDelta;
            sin = tempCos * sinDelta + sin * cosDelta;
            float[] innerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, innerRadius, cos, sin, direction);
            float[] outerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radius, cos, sin, direction);
            RenderUtil.fill(guiGraphics, innerPoint[0], innerPoint[1], outerPoint[0], outerPoint[1], frameColor);
        }
    }

    public static void drawVertexSuperellipseFrame(class_332 guiGraphics, float centerX, float centerY, float radiusX, float radiusY, float exponent, int frameColor, float frameThickness, VertexDirection direction) {
        int steps = 36;
        float angleStep = 1.5707964f / (float)steps;
        float correctedExponent = 2.0f / exponent;
        float cos = 1.0f;
        float sin = 0.0f;
        float cosDelta = class_3532.method_15362((double)angleStep);
        float sinDelta = class_3532.method_15374((double)angleStep);
        for (int i = 0; i < steps; ++i) {
            float tempCos = cos;
            cos = cos * cosDelta - sin * sinDelta;
            sin = tempCos * sinDelta + sin * cosDelta;
            float projX = (float)Math.pow(class_3532.method_15379((float)cos), correctedExponent);
            float projY = (float)Math.pow(class_3532.method_15379((float)sin), correctedExponent);
            float[] innerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radiusX - frameThickness, radiusY - frameThickness, projX, projY, direction);
            float[] outerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radiusX, radiusY, projX, projY, direction);
            RenderUtil.fill(guiGraphics, innerPoint[0], innerPoint[1], outerPoint[0], outerPoint[1], frameColor);
        }
    }

    private static float[] calculateVertexDirectionPoint(float centerX, float centerY, float radius, float projX, float projY, VertexDirection direction) {
        return RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radius, radius, projX, projY, direction);
    }

    private static float[] calculateVertexDirectionPoint(float centerX, float centerY, float radiusX, float radiusY, float projX, float projY, VertexDirection direction) {
        float x;
        return new float[]{x, switch (direction.ordinal()) {
            case 0 -> {
                x = centerX - radiusX * projX;
                yield centerY - radiusY * projY;
            }
            case 1 -> {
                x = centerX + radiusX * projX;
                yield centerY - radiusY * projY;
            }
            case 2 -> {
                x = centerX - radiusX * projX;
                yield centerY + radiusY * projY;
            }
            case 3 -> {
                x = centerX + radiusX * projX;
                yield centerY + radiusY * projY;
            }
            default -> throw new IllegalArgumentException("Invalid VertexDirection");
        }};
    }

    public static enum VertexDirection {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

