/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.config.ServerClassPolicy;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.network.handler.PayloadHandler;
import dev.terminalmc.clientsort.network.handler.validate.PolicyManager;
import dev.terminalmc.clientsort.network.handler.validate.SchemaValidator;
import dev.terminalmc.clientsort.network.payload.TransferPayload;
import dev.terminalmc.clientsort.network.payload.TransferResultPayload;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TransferHandler
extends PayloadHandler {
    private TransferHandler() {
    }

    public static void handle(TransferPayload payload, MinecraftServer server, class_3222 player) {
        server.execute(() -> TransferHandler.processPayload(server, player, payload.srcContainerId(), menu -> TransferHandler.checkPolicy(menu, payload.srcSlotIds(), payload.dstSlotIds()), menu -> {
            SchemaValidator.validateSlotArray(player, menu, payload.srcSlotIds());
            SchemaValidator.validateSlotArray(player, menu, payload.dstSlotIds());
        }, menu -> TransferHandler.transfer(server, menu, payload.srcSlotIds(), payload.dstSlotIds(), payload.reversed()), TransferPayload.TYPE, TransferResultPayload.TYPE, (result, message) -> new TransferResultPayload(result.code, (String)message)));
    }

    private static void transfer(MinecraftServer server, class_1703 menu, int[] srcSlotIds, int[] dstSlotIds, boolean reversed) throws PayloadHandlerException {
        int start = reversed ? srcSlotIds.length - 1 : 0;
        Function<Integer, Boolean> end = reversed ? i -> i >= 0 : i -> i < srcSlotIds.length;
        Function<Integer, Integer> step = reversed ? i -> i - 1 : i -> i + 1;
        int i2 = start;
        while (end.apply(i2).booleanValue()) {
            int srcSlotId = srcSlotIds[i2];
            class_1735 srcSlot = (class_1735)menu.field_7761.get(srcSlotId);
            class_1799 srcStack = srcSlot.method_7677();
            class_1799 srcStackCopy = srcStack.method_7972();
            if (!srcStack.method_7960()) {
                class_1799 expected;
                class_1799 dstStackCopy;
                class_1799 dstStack;
                class_1735 dstSlot;
                for (int dstSlotId : dstSlotIds) {
                    dstSlot = (class_1735)menu.field_7761.get(dstSlotId);
                    dstStack = dstSlot.method_7677();
                    dstStackCopy = dstStack.method_7972();
                    if (dstStack.method_7960() || dstStack.method_7947() >= dstSlot.method_7676(dstStack) || !class_1799.method_31577((class_1799)srcStack, (class_1799)dstStack)) continue;
                    expected = srcStack.method_46651(Math.min(srcStack.method_7947() + dstStack.method_7947(), dstSlot.method_7676(dstStack)));
                    dstSlot.method_32756(srcStack);
                    TransferHandler.validate(server, expected, dstSlot.method_7677(), () -> String.format("Transfer operation failed to safe-insert from slot %d with item '%s' to slot %d with item '%s'", srcSlotId, srcStackCopy, dstSlotId, dstStackCopy), msg -> TransferHandler.setPolicy(menu, dstSlotIds, msg));
                    if (srcStack.method_7960()) break;
                }
                if (!srcStack.method_7960()) {
                    for (int dstSlotId : dstSlotIds) {
                        dstSlot = (class_1735)menu.field_7761.get(dstSlotId);
                        dstStack = dstSlot.method_7677();
                        dstStackCopy = dstStack.method_7972();
                        if (!dstStack.method_7960()) continue;
                        expected = srcStack.method_46651(Math.min(srcStack.method_7947(), dstSlot.method_7676(srcStack)));
                        dstSlot.method_32756(srcStack);
                        TransferHandler.validate(server, expected, dstSlot.method_7677(), () -> String.format("Transfer operation failed to safe-insert from slot %d with item '%s' to slot %d with item '%s'", srcSlotId, srcStackCopy, dstSlotId, dstStackCopy), msg -> TransferHandler.setPolicy(menu, dstSlotIds, msg));
                        break;
                    }
                }
            }
            i2 = step.apply(i2);
        }
    }

    private static void checkPolicy(class_1703 menu, int[] srcSlotIds, int[] dstSlotIds) throws PayloadHandlerException.UnsupportedOpException {
        class_1263 srcContainer = srcSlotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)srcSlotIds[0])).field_7871 : null;
        Object srcObject = ClientSort.getObj(srcContainer, menu);
        if (srcObject == null) {
            throw new PayloadHandlerException.UnsupportedOpException("Reference src object is null for inputs '%s', '%s'!".formatted(srcContainer == null ? "null" : srcContainer.getClass().getName(), menu == null ? "null" : menu.getClass().getName()));
        }
        class_1263 dstContainer = dstSlotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)dstSlotIds[0])).field_7871 : null;
        Object dstObject = ClientSort.getObj(dstContainer, menu);
        if (dstObject == null) {
            throw new PayloadHandlerException.UnsupportedOpException("Reference dst object is null for inputs '%s', '%s'!".formatted(dstContainer == null ? "null" : dstContainer.getClass().getName(), menu == null ? "null" : menu.getClass().getName()));
        }
        PolicyManager.checkPolicy(srcObject.getClass(), bl -> bl.transferEnabled);
        PolicyManager.checkPolicy(dstObject.getClass(), bl -> bl.transferEnabled);
    }

    private static void setPolicy(class_1703 menu, int[] dstSlotIds, String message) {
        class_1263 dstContainer = dstSlotIds.length > 0 ? ((class_1735)menu.field_7761.get((int)dstSlotIds[0])).field_7871 : null;
        Object object = ClientSort.getObj(dstContainer, menu);
        if (object == null) {
            ClientSort.LOG.warn("Could not set policy: reference object is null for inputs '{}', '{}'!", dstContainer == null ? "null" : dstContainer.getClass().getName(), menu == null ? "null" : menu.getClass().getName());
            return;
        }
        PolicyManager.setPolicy(new ServerClassPolicy(object.getClass().getName(), true, true, false), TransferPayload.ID.toString(), message);
    }
}

